package com.xforceplus.janus.flow.cache.core;


import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock.ReadLock;
import java.util.concurrent.locks.ReentrantReadWriteLock.WriteLock;


/**
 * cache
 * @author xuchuanhou
 */
public class BasicCache<K, V> {
    private final Map<K, V> cache = new HashMap<K, V>();

    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReadLock readLock = cacheLock.readLock();
    private final WriteLock writeLock = cacheLock.writeLock();

    public V get(K key) {
        // 尝试读取缓存
        V value;
        readLock.lock();
        try {
            value = cache.get(key);
        } finally {
            readLock.unlock();
        }
        return value;
    }

    public V put(K key, V value) {
        writeLock.lock();
        try {
            cache.put(key, value);
        } finally {
            writeLock.unlock();
        }
        return value;
    }
}
