package com.xforceplus.janus.flow.cache.factory;

import com.xforceplus.janus.flow.cache.manager.CacheManager;

import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * cache 管理器
 * @author xuchuanhou
 */
@Component
public class CacheFactory {

    /**所有cacheManager*/
    private final Map<String, CacheManager> cacheManagers = new ConcurrentHashMap<>(256);

    /***
     * 根据name 获取 CacheManager
     */
    public CacheManager getCacheManager(String cacheName) {
        return this.cacheManagers.get(cacheName);
    }
    /***
     * 增加 CacheManager
     */
    public void addCacheManager(String cacheName, CacheManager cacheManager) {
        synchronized (cacheManagers) {
            this.cacheManagers.put(cacheName, cacheManager);
        }
    }
    /***
     * 移除 CacheManager
     */
    public void removeCacheManager(String beanName) {
        synchronized (this.cacheManagers) {
            CacheManager cacheManager = cacheManagers.get(beanName);
            if (cacheManager != null) {
                cacheManager.clear();
            }
        }
    }
}
