package com.xforceplus.janus.flow.cache.manager;

import com.jayway.jsonpath.JsonPath;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.gavacache.JanusAbstractLoadingCache;
import com.xforceplus.janus.commons.http.HttpUtil;
import com.xforceplus.janus.commons.http.ResponseCus;
import com.xforceplus.janus.flow.cache.model.ApiCacheModel;
import com.xforceplus.janus.flow.logic.model.ApiConfig;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

import cn.hutool.json.JSONUtil;
import io.swagger.models.HttpMethod;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * 加入本地缓存
 */
@Slf4j
@Data
public class ApiLocalCacheManager extends JanusAbstractLoadingCache<String, Object> implements CacheManager<String, Object> {

    private ApiCacheModel apiCacheModel;

    public ApiLocalCacheManager(ApiCacheModel apiCacheModel) {
        this.apiCacheModel = apiCacheModel;
    }

    @Override
    public Object get(TreeMap<String, String> param) {
        try {
            apiCacheModel.setParams(param);
            return get(apiCacheModel.getKey());
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object get(String key) {
        try {
            return this.getValue(key);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Object fetchData(String key) {
        try {
            ResponseCus rep = null;
            ApiConfig apiConfig = apiCacheModel.getApiConfig();
            if (HttpMethod.GET.name().equalsIgnoreCase(apiConfig.getHttpMethod())) {
                rep = HttpUtil.doGetEntire(apiConfig.getHost(),
                        apiConfig.getParams(), true, apiConfig.getHeaders());
            } else if (HttpMethod.POST.name().equalsIgnoreCase(apiConfig.getHttpMethod())) {
                String body = null;
                if (StringUtils.isNotBlank(apiConfig.getBody())) {
                    if (JSONUtil.isJsonArray(apiConfig.getBody())) {
                        List<String> keys = JacksonUtil.getInstance().fromJsonToList(apiConfig.getBody(), String.class);
                        if (CollectionUtils.isEmpty(keys)) {
                            log.warn("body is empty");
                            return null;
                        }
                        Set<String> keySet = new HashSet<>(keys);
                        body = JacksonUtil.getInstance().toJson(keySet);
                    }else{
                        body=apiConfig.getBody();
                    }
                }
                rep = HttpUtil.doPostJsonEntire(apiConfig.getHost(), body, apiConfig.getHeaders(), apiConfig.getParams());
            }else{
                log.error("not support");
            }

            if (rep.getStatus() != HttpStatus.SC_OK) {
                log.error("{} fetchdata by key{}", apiCacheModel.getCacheName(), apiCacheModel.getKey());
                return null;
            }
            if(StringUtils.isBlank(apiCacheModel.getApiConfig().getResultPath())){
                return rep.getBody();
            }else{
                return JsonPath.read(rep.getBody(), apiCacheModel.getApiConfig().getResultPath());
            }
        } catch (Exception ex) {
            log.error("{} fetchdata by key{} exception:{}", apiCacheModel.getCacheName(), apiCacheModel.getKey(), ex.getLocalizedMessage());
        }

        return null;
    }

    @Override
    protected long getExpireAfterWrite() {
        return apiCacheModel.getExpire();
    }

    @Override
    public void clear() {
        this.getCache().cleanUp();
        this.getCache().invalidateAll();
    }
}