package com.xforceplus.janus.flow.cache.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;


import java.io.Serializable;
import java.util.TreeMap;

import lombok.Data;

@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class CacheModel implements Serializable {

    public static final long DEFAULT_EXPIRE=300;

    public static String CACHE_TYPE_LOCAL = "1";
    public static String CACHE_TYPE_REDIS = "2";

    /**
     * cache 名称
     */
    private String cacheName;

    /**
     * cache过期时间 单位 s
     */
    private long expire=DEFAULT_EXPIRE;
    /**
     * 1:local 2:redis
     */
    private String type;

    /**
     * 提取缓存参数
     */
    private TreeMap<String, String> params;


    public String getKey() {
        return cacheName+ String.join("-",params.values());
    }


}
