/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.flow.cache.factory;

import com.xforceplus.janus.flow.cache.manager.CacheManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class CacheFactory {
    private final Map<String, CacheManager> cacheManagers = new ConcurrentHashMap<String, CacheManager>(256);

    public CacheManager getCacheManager(String cacheName) {
        return this.cacheManagers.get(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheManager(String cacheName, CacheManager cacheManager) {
        Map<String, CacheManager> map = this.cacheManagers;
        synchronized (map) {
            this.cacheManagers.put(cacheName, cacheManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheManager(String beanName) {
        Map<String, CacheManager> map = this.cacheManagers;
        synchronized (map) {
            CacheManager cacheManager = this.cacheManagers.get(beanName);
            if (cacheManager != null) {
                cacheManager.clear();
            }
        }
    }
}

