/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.flow.cache.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BasicCache<K, V> {
    private final Map<K, V> cache = new HashMap();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();

    public V get(K key) {
        V value;
        this.readLock.lock();
        try {
            value = this.cache.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        return value;
    }

    public V put(K key, V value) {
        this.writeLock.lock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
        return value;
    }
}

