/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.flow.cache.manager;

import cn.hutool.json.JSONUtil;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.gavacache.JanusAbstractLoadingCache;
import com.xforceplus.janus.commons.http.HttpUtil;
import com.xforceplus.janus.commons.http.ResponseCus;
import com.xforceplus.janus.flow.cache.manager.CacheManager;
import com.xforceplus.janus.flow.cache.model.ApiCacheModel;
import com.xforceplus.janus.flow.logic.model.ApiConfig;
import io.swagger.models.HttpMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiLocalCacheManager
extends JanusAbstractLoadingCache<String, Object>
implements CacheManager<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(ApiLocalCacheManager.class);
    private ApiCacheModel apiCacheModel;

    public ApiLocalCacheManager(ApiCacheModel apiCacheModel) {
        this.apiCacheModel = apiCacheModel;
    }

    @Override
    public Object get(TreeMap<String, String> param) {
        try {
            this.apiCacheModel.setParams(param);
            return this.get(this.apiCacheModel.getKey());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object get(String key) {
        try {
            return this.getValue(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object fetchData(String key) {
        try {
            ResponseCus rep = null;
            ApiConfig apiConfig = this.apiCacheModel.getApiConfig();
            if (HttpMethod.GET.name().equalsIgnoreCase(apiConfig.getHttpMethod())) {
                rep = HttpUtil.doGetEntire((String)apiConfig.getHost(), (Map)apiConfig.getParams(), (boolean)true, (Map)apiConfig.getHeaders());
            } else if (HttpMethod.POST.name().equalsIgnoreCase(apiConfig.getHttpMethod())) {
                String body = null;
                if (StringUtils.isNotBlank((CharSequence)apiConfig.getBody())) {
                    if (JSONUtil.isJsonArray((String)apiConfig.getBody())) {
                        List keys = JacksonUtil.getInstance().fromJsonToList(apiConfig.getBody(), String.class);
                        if (CollectionUtils.isEmpty((Collection)keys)) {
                            log.warn("body is empty");
                            return null;
                        }
                        HashSet keySet = new HashSet(keys);
                        body = JacksonUtil.getInstance().toJson(keySet);
                    } else {
                        body = apiConfig.getBody();
                    }
                }
                rep = HttpUtil.doPostJsonEntire((String)apiConfig.getHost(), (String)body, (Map)apiConfig.getHeaders(), (Map)apiConfig.getParams());
            } else {
                log.error("not support");
            }
            if (rep.getStatus() != 200) {
                log.error("{} fetchdata by key{}", (Object)this.apiCacheModel.getCacheName(), (Object)this.apiCacheModel.getKey());
                return null;
            }
            if (StringUtils.isBlank((CharSequence)this.apiCacheModel.getApiConfig().getResultPath())) {
                return rep.getBody();
            }
            return JsonPath.read((String)rep.getBody(), (String)this.apiCacheModel.getApiConfig().getResultPath(), (Predicate[])new Predicate[0]);
        }
        catch (Exception ex) {
            log.error("{} fetchdata by key{} exception:{}", new Object[]{this.apiCacheModel.getCacheName(), this.apiCacheModel.getKey(), ex.getLocalizedMessage()});
            return null;
        }
    }

    protected long getExpireAfterWrite() {
        return this.apiCacheModel.getExpire();
    }

    @Override
    public void clear() {
        this.getCache().cleanUp();
        this.getCache().invalidateAll();
    }

    public ApiCacheModel getApiCacheModel() {
        return this.apiCacheModel;
    }

    public void setApiCacheModel(ApiCacheModel apiCacheModel) {
        this.apiCacheModel = apiCacheModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiLocalCacheManager)) {
            return false;
        }
        ApiLocalCacheManager other = (ApiLocalCacheManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiCacheModel this$apiCacheModel = this.getApiCacheModel();
        ApiCacheModel other$apiCacheModel = other.getApiCacheModel();
        return !(this$apiCacheModel == null ? other$apiCacheModel != null : !((Object)this$apiCacheModel).equals(other$apiCacheModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiLocalCacheManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiCacheModel $apiCacheModel = this.getApiCacheModel();
        result = result * 59 + ($apiCacheModel == null ? 43 : ((Object)$apiCacheModel).hashCode());
        return result;
    }

    public String toString() {
        return "ApiLocalCacheManager(apiCacheModel=" + this.getApiCacheModel() + ")";
    }
}

