package com.xforceplus.janus.flow.logic.handle;


import com.jayway.jsonpath.JsonPath;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.http.HttpUtil;
import com.xforceplus.janus.commons.http.ResponseCus;
import com.xforceplus.janus.flow.logic.model.ApiConfig;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.hutool.json.JSONUtil;
import io.swagger.models.HttpMethod;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ApiHandler extends LogicHandler {

    private ApiConfig apiConfig;

    public ApiHandler() {
    }

    public ApiHandler(ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
    }

    @Override
    void doHandler() {
        String apiResult = null;
        try {
            apiResult = invokeApi(apiConfig.getHost(), HttpMethod.valueOf(apiConfig.getHttpMethod()),
                    apiConfig.getHeaders(), apiConfig.getParams(), apiConfig.getBody());
        } catch (Exception ex) {
            log.error("api {} exception:{}", apiConfig.getHost(), ErrorUtil.getStackMsg(ex));
        }
        if (StringUtils.isBlank(apiResult)) {
            return;
        }

        String needResult = apiResult;
        if (StringUtils.isNotBlank(apiConfig.getResultPath())) {
            Object tmpResult  = JsonPath.read(apiResult, apiConfig.getResultPath());
            if(tmpResult instanceof String){
                needResult =(String)tmpResult;
            }else {
                needResult=JacksonUtil.getInstance().toJson(tmpResult);
            }
        }

        Object result = needResult;
        if (JSONUtil.isJsonArray(needResult)) {
            result = JacksonUtil.getInstance().fromJsonToList(needResult, Map.class);
        } else if (JSONUtil.isJson(needResult)) {
            result = JacksonUtil.getInstance().fromJson(needResult, Map.class);
        }
        super.appendFiled(apiConfig.getTargetField(), result);
    }

    public static String invokeApi(String url, HttpMethod method, Map<String, String> headers, Map<String, String> params, String body)
            throws IOException {
        ResponseCus rep = null;
        if (method == HttpMethod.GET) {
            rep = HttpUtil.doGetEntire(url, params, true, headers);
        } else if (method == HttpMethod.POST) {
            if (StringUtils.isNotBlank(body)) {
                if (JSONUtil.isJsonArray(body)) {
                    List<String> keys = JacksonUtil.getInstance().fromJsonToList(body, String.class);
                    if (CollectionUtils.isEmpty(keys)) {
                        log.warn("body is empty");
                        return null;
                    }
                    Set<String> keySet = new HashSet<>(keys);
                    body = JacksonUtil.getInstance().toJson(keySet);
                }
            }
            rep = HttpUtil.doPostJsonEntire(url, body, headers, params);
        }
        if (rep.getStatus() != HttpStatus.SC_OK) {
            log.error("调用接口异常,url:{},headers:{},params:{}",url,headers,params);
            return null;
        }
        return rep.getBody();
    }
}
