package com.xforceplus.janus.flow.logic.model;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@ApiModel("api调用定义")
public class ApiConfig implements Serializable {

    private static final long serialVersionUID = -3002824379418849215L;
    private String host;

    private String httpMethod;

    /**
     * api请求header字段与value值来源
     */
    private Map<String, String> headers;

    /**
     * 参数字段名称与value值来源
     */
    private Map<String, String> params;

    private String body;

    /** api请求header字段与value值来源 */
    @ApiModelProperty("header字段与value值来源")
    private List<FieldMappingDto> headerKeys;

    /** 参数字段名称与value值来源 */
    @ApiModelProperty("参数字段与value值来源")
    private List<FieldMappingDto> paramsKeys;

    /** 请求参数body来源的字段名 slot里面的key */
    @ApiModelProperty("body value值来源")
    private String bodyKey;
    /** body json结构 构造字段 */

    @ApiModelProperty("body 从多个字段组成value来源")
    private List<FieldMappingDto> bodyBuildKeys;

    @ApiModelProperty("api结果提取")
    private String resultPath;

    @ApiModelProperty("结果存放字段")
    private String targetField;

}
