package com.xforceplus.janus.flow.logic.model;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.apollo.zookeeper.model.Condition;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 后续改造成子流程处理
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("条件处理")
@Data
public class ConditionHander implements Serializable {

    private static final long serialVersionUID = -2537015058149015551L;

    private String id;
//
    @ApiModelProperty("条件")
    private List<CusCondition> conditions;

    @ApiModelProperty(hidden = true)
    private Map<String,String> conditionParam;

    /**
     * AND
     */
    @ApiModelProperty("条件匹配方式 and or")
    private String matchModel;

    /**执行顺序*/
    @ApiModelProperty("执行顺序")
    private int sort;

    /**
     * 处理器
     */
    @ApiModelProperty("处理程序列表")
    List<HandlerConfig> handlerConfigs;

}
