package com.xforceplus.janus.flow.logic.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @program: flow-server->FieldMappingDto
 * @description: 字段映射
 * @author: xuchuanhou
 * @create: 2020-12-08 11:16
 **/
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class FieldMappingDto implements Serializable {
    private static final long serialVersionUID = -5884235032683026663L;
    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段值名称 slot里面的key
     */
    private String fieldValueName;

    /**
     * fieldValueName 为空时取
     */
    private String defaultValue;

    public FieldMappingDto() {

    }

    public FieldMappingDto(String fieldName, String fieldValueName, String defaultValue) {
        this.fieldName = fieldName;
        this.fieldValueName = fieldValueName;
        this.defaultValue = defaultValue;
    }
}
