package com.xforceplus.janus.flow.logic.model;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.janus.flow.logic.enums.HandleType;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@ApiModel("业务逻辑处理")
public  class HandlerConfig implements Serializable {

    private static final long serialVersionUID = -6517214007300369335L;
    private String id;

    /**1:调用api接口*/
    @ApiModelProperty("处理方式 API WORDEX")
    private String type;

    /**处理顺序*/
    @ApiModelProperty("处理顺序")
    private int sort;

    @ApiModelProperty("api调用参数")
    private ApiConfig apiConfig;

    /**词法表达式*/
    @ApiModelProperty("语法计算表达式")
    private WordExpressConfig wordExpressConfig;

}
