/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.flow.logic.handle;

import cn.hutool.json.JSONUtil;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.http.HttpUtil;
import com.xforceplus.janus.commons.http.ResponseCus;
import com.xforceplus.janus.flow.logic.handle.LogicHandler;
import com.xforceplus.janus.flow.logic.model.ApiConfig;
import io.swagger.models.HttpMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiHandler
extends LogicHandler {
    private static final Logger log = LoggerFactory.getLogger(ApiHandler.class);
    private ApiConfig apiConfig;

    public ApiHandler() {
    }

    public ApiHandler(ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
    }

    @Override
    void doHandler() {
        String apiResult = null;
        try {
            apiResult = ApiHandler.invokeApi(this.apiConfig.getHost(), HttpMethod.valueOf((String)this.apiConfig.getHttpMethod()), this.apiConfig.getHeaders(), this.apiConfig.getParams(), this.apiConfig.getBody());
        }
        catch (Exception ex) {
            log.error("api {} exception:{}", (Object)this.apiConfig.getHost(), (Object)ErrorUtil.getStackMsg((Exception)ex));
        }
        if (StringUtils.isBlank(apiResult)) {
            return;
        }
        String needResult = apiResult;
        if (StringUtils.isNotBlank((CharSequence)this.apiConfig.getResultPath())) {
            Object tmpResult = JsonPath.read((String)apiResult, (String)this.apiConfig.getResultPath(), (Predicate[])new Predicate[0]);
            needResult = tmpResult instanceof String ? (String)tmpResult : JacksonUtil.getInstance().toJson(tmpResult);
        }
        Object result = needResult;
        if (JSONUtil.isJsonArray((String)needResult)) {
            result = JacksonUtil.getInstance().fromJsonToList(needResult, Map.class);
        } else if (JSONUtil.isJson((String)needResult)) {
            result = JacksonUtil.getInstance().fromJson(needResult, Map.class);
        }
        super.appendFiled(this.apiConfig.getTargetField(), result);
    }

    public static String invokeApi(String url, HttpMethod method, Map<String, String> headers, Map<String, String> params, String body) throws IOException {
        ResponseCus rep = null;
        if (method == HttpMethod.GET) {
            rep = HttpUtil.doGetEntire((String)url, params, (boolean)true, headers);
        } else if (method == HttpMethod.POST) {
            if (StringUtils.isNotBlank((CharSequence)body) && JSONUtil.isJsonArray((String)body)) {
                List keys = JacksonUtil.getInstance().fromJsonToList(body, String.class);
                if (CollectionUtils.isEmpty((Collection)keys)) {
                    log.warn("body is empty");
                    return null;
                }
                HashSet keySet = new HashSet(keys);
                body = JacksonUtil.getInstance().toJson(keySet);
            }
            rep = HttpUtil.doPostJsonEntire((String)url, (String)body, headers, params);
        }
        if (rep.getStatus() != 200) {
            log.error("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38,url:{},headers:{},params:{}", new Object[]{url, headers, params});
            return null;
        }
        return rep.getBody();
    }
}

