package com.xforceplus.janus.flow.logic.handle;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;

import org.apache.commons.lang3.StringUtils;

public abstract class LogicHandler {

    public static TransmittableThreadLocal<Object> content = new TransmittableThreadLocal<Object>();

    public void execute() {

        doHandler();

    }

    abstract void doHandler();

    protected void appendFiled(String fieldPath, Object value) {
        String path = null;
        String key = null;

        if (fieldPath.contains(".")) {
            path = fieldPath.substring(0, fieldPath.lastIndexOf("."));
            key = fieldPath.substring(fieldPath.lastIndexOf(".") + 1);
        } else {
            path = "$";
            key = fieldPath;
        }

        DocumentContext documentContext = JsonPath.parse(content.get(), Configuration.defaultConfiguration().addOptions(
                Option.SUPPRESS_EXCEPTIONS));
        documentContext.put(path, key, value);
        Object reuslt = documentContext.json();
        if (reuslt != null) {
            content.set(reuslt);
        }
    }

    String readField(String path) {
        DocumentContext documentContext = JsonPath.parse(content.get(), Configuration.defaultConfiguration().addOptions(
                Option.SUPPRESS_EXCEPTIONS));
        return documentContext.read(path);
    }

}
