package com.xforceplus.janus.flow.logic.handle;


import com.xforceplus.janus.flow.logic.model.WordExpressConfig;

import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class WordExpressionHandler extends LogicHandler {

    private WordExpressConfig wordExpressConfig;

    public WordExpressionHandler() {

    }

    public WordExpressionHandler(WordExpressConfig wordExpressHandle) {
        this.wordExpressConfig = wordExpressHandle;
    }

    @Override
    void doHandler() {
        if (StringUtils.isNotBlank(wordExpressConfig.getExtractExpressField())) {
            String express = this.readField(wordExpressConfig.getExtractExpressField());
            if (express != null) {
                wordExpressConfig.setExtractExpress(express);
            }
        }

        ExpressionParser expressionParser = new SpelExpressionParser();
        Expression expression = expressionParser.parseExpression(wordExpressConfig.getExtractExpress());
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext(content.get());

        String result = expression.getValue(standardEvaluationContext, String.class);
        super.appendFiled(wordExpressConfig.getTargetField(), result);
    }
}
