package com.xforceplus.janus.flow.logic.dynamic;



import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.xforceplus.apollo.condition.MatchModeEnum;
import com.xforceplus.apollo.condition.strategy.MatchStrategyFactory;
import com.xforceplus.apollo.zookeeper.model.Condition;
import com.xforceplus.janus.flow.logic.enums.HandleType;
import com.xforceplus.janus.flow.logic.handle.ApiHandler;
import com.xforceplus.janus.flow.logic.handle.LogicHandler;
import com.xforceplus.janus.flow.logic.handle.WordExpressionHandler;
import com.xforceplus.janus.flow.logic.model.ConditionHander;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DynamicHandler {

    public void dynamicHandler(Object source, List<ConditionHander> conditionHanders) {
        try {
            conditionHanders.forEach(conditionHander -> {

              List<Condition> condits =  conditionHander.getConditions().stream().collect(Collectors.toList());
                boolean match =
                        MatchStrategyFactory.of(MatchModeEnum.getMatchModeByName(conditionHander.getMatchModel()).getCode())
                                .match(condits, conditionHander.getConditionParam());
                if (match) {
                    //执行hands
                    conditionHander.getHandlerConfigs().sort(Comparator.comparingInt(h -> h.getSort()));
                    conditionHander.getHandlerConfigs().forEach(handlerConfig -> {
                        //执行hander;
                        LogicHandler logicHandler = null;
                        if (HandleType.API.getCode().equals(handlerConfig.getType())) {
                            logicHandler = new ApiHandler(handlerConfig.getApiConfig());
                        } else if (HandleType.WordExp.getCode().equals(handlerConfig.getType())) {
                            logicHandler = new WordExpressionHandler(handlerConfig.getWordExpressConfig());
                        }
                        if (LogicHandler.content.get() == null) {
                            LogicHandler.content.set(source);
                        }
                        logicHandler.execute();
                    });
                }
            });

        } finally {
            LogicHandler.content.remove();
        }
    }

}
