package com.xforceplus.janus.flow.logic.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import lombok.Data;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("词法提取定义")
@Data
public class WordExpressConfig implements Serializable {

    private static final long serialVersionUID = 8029264447087666334L;

    /**自定义业务模型代码*/
    private String businessCode;

    /**
     * 提取目标字段
     */
    private String targetField;

    /**
     * 词法提取表达式 SPEL表达式
     */
    private String extractExpress;

    /** 提取表达式字段 */
    private String extractExpressField;

    /**
     * 中文词法表达式
     */
    private String extractExpressCN;

}
