/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.flow.logic.dynamic;

import com.xforceplus.apollo.condition.MatchModeEnum;
import com.xforceplus.apollo.condition.strategy.MatchStrategyFactory;
import com.xforceplus.janus.flow.logic.enums.HandleType;
import com.xforceplus.janus.flow.logic.handle.ApiHandler;
import com.xforceplus.janus.flow.logic.handle.LogicHandler;
import com.xforceplus.janus.flow.logic.handle.WordExpressionHandler;
import com.xforceplus.janus.flow.logic.model.ConditionHander;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class DynamicHandler {
    public void dynamicHandler(Object source, List<ConditionHander> conditionHanders) {
        try {
            conditionHanders.forEach(conditionHander -> {
                List condits = conditionHander.getConditions().stream().collect(Collectors.toList());
                boolean match = MatchStrategyFactory.of((Integer)MatchModeEnum.getMatchModeByName((String)conditionHander.getMatchModel()).getCode()).match(condits, conditionHander.getConditionParam());
                if (match) {
                    conditionHander.getHandlerConfigs().sort(Comparator.comparingInt(h -> h.getSort()));
                    conditionHander.getHandlerConfigs().forEach(handlerConfig -> {
                        LogicHandler logicHandler = null;
                        if (HandleType.API.getCode().equals(handlerConfig.getType())) {
                            logicHandler = new ApiHandler(handlerConfig.getApiConfig());
                        } else if (HandleType.WordExp.getCode().equals(handlerConfig.getType())) {
                            logicHandler = new WordExpressionHandler(handlerConfig.getWordExpressConfig());
                        }
                        if (LogicHandler.content.get() == null) {
                            LogicHandler.content.set(source);
                        }
                        logicHandler.execute();
                    });
                }
            });
        }
        finally {
            LogicHandler.content.remove();
        }
    }
}

