package com.xforceplus.janus.flow.springboot;

import com.xforceplus.janus.flow.core.core.FlowExecutor;
import com.xforceplus.janus.flow.core.minitor.MonitorBus;
import com.xforceplus.janus.flow.core.spring.ExecutorScaner;
import com.xforceplus.janus.flow.core.spring.SpringAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FlowAutoConfiguration {

    @Bean
    public SpringAware springAware() {
        return new SpringAware();
    }

    @Bean
    public FlowExecutor flowExecutor() {
        return new FlowExecutor();
    }

    @Bean
    public ExecutorScaner executorScaner() {
        return new ExecutorScaner();
    }

    @Bean
    public FlowExecutorInit liteflowExecutorInit(FlowExecutor flowExecutor) {
        return new FlowExecutorInit(flowExecutor);
    }

    @Bean
    public MonitorBus monitorBus() {
        return new MonitorBus();
    }

}
