package com.xforceplus.janus.flow.sys.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.xforceplus.janus.commons.dto.BaseEntity;

import java.io.Serializable;

import lombok.Data;

/***
 * 缓存定义 采用本地缓存+远程方式
 */
@TableName("t_janus_flow_cache")
@Data
public class CacheDefineEntity extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 4619091327104000134L;

    public static String CACHE_TYPE_LOCAL = "1";
    public static String CACHE_TYPE_REDIS = "2";

    /***缓存名称*/
    private String name;

    /**
     * 缓存过期时间 redis 使用
     */
    private long ttl;
    /**
     * 淘汰策略  local 使用  LRU FIFO
     */
    private String evictPolicy;

    /**1:本地 2:redis*/
    private String type;

    /**调用拓展字段标识*/
    private String action;
    /**调用拓展字段标识*/
    private String ext1;

    /**
     * 缓存获取字段
     */
    private String properties;

}
