package com.xforceplus.janus.flow.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.commons.util.PageUtils;
import com.xforceplus.janus.dbs.common.Query;
import com.xforceplus.janus.flow.sys.dao.CacheDefineDao;
import com.xforceplus.janus.flow.sys.entity.CacheDefineEntity;
import com.xforceplus.janus.flow.sys.param.CacheDefinePageParam;
import com.xforceplus.janus.flow.sys.service.CacheDefineService;
import com.xforceplus.janus.flow.sys.util.Constant;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

/**
 * @author xuchuanhou
 */
@Service
public class CacheDefineServiceImpl extends ServiceImpl<CacheDefineDao, CacheDefineEntity> implements CacheDefineService {

    @Override
    public PageUtils queryPage(CacheDefinePageParam param) {
        IPage<CacheDefineEntity> page = this.page(new Query<CacheDefineEntity>().getPage(param),
                new QueryWrapper<CacheDefineEntity>()
                        .eq(StringUtils.isNotBlank(param.getName()), "name", param.getName())
                        .eq(StringUtils.isNotBlank(param.getType()), "type", param.getType())
                        .eq(Constant.IS_VALID, Constant.IS_VALIDED)

        );

        return new PageUtils(page);
    }

    @Override
    public boolean logicDelete(String id) {
        this.update(new UpdateWrapper<CacheDefineEntity>()
                .set(Constant.IS_VALID, Constant.IS_NOT_VALIDED)
                .eq("id", id));
        return false;
    }

    /**
     * @see com.xforceplus.janus.flow.sys.service.CacheDefineService#getByActon(String)
     */
    @Override
    public CacheDefineEntity getByActon(String action) {
        return this.getOne(new QueryWrapper<CacheDefineEntity>()
                .eq(Constant.IS_VALID, Constant.IS_VALIDED)
                .eq("action", action)
        );
    }
}
