package com.xforceplus.janus.flow.sys.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.commons.util.PageUtils;
import com.xforceplus.janus.dbs.common.Query;
import com.xforceplus.janus.flow.sys.dao.FlowLogicDataDao;
import com.xforceplus.janus.flow.sys.entity.FlowLogicModelData;
import com.xforceplus.janus.flow.sys.param.LogicModelDataPageParam;
import com.xforceplus.janus.flow.sys.param.LogicModelDataParam;
import com.xforceplus.janus.flow.sys.service.FlowLogicDataService;
import com.xforceplus.janus.flow.sys.util.Constant;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class FlowLogicDataServiceImpl extends ServiceImpl<FlowLogicDataDao, FlowLogicModelData> implements FlowLogicDataService {
    @Override
    public List<FlowLogicModelData> queryLogicData(LogicModelDataParam param) {

        return this.list(new QueryWrapper<FlowLogicModelData>()
                .eq("tenant_id", param.getTenantId())
                .eq("business_code", param.getBusinessCode())
                .eq(StringUtils.isNotBlank(param.getExt1()), "ext1", param.getExt1())
                .eq(StringUtils.isNotBlank(param.getExt2()), "ext2", param.getExt2())
                .eq(StringUtils.isNotBlank(param.getExt3()), "ext3", param.getExt3())
                .eq(Constant.IS_VALID, Constant.IS_VALIDED)
                .last("limit 10")
        );
    }

    @Override
    public PageUtils queryPage(LogicModelDataPageParam param) {
        IPage<FlowLogicModelData> page = this.page(new Query<FlowLogicModelData>().getPage(param),
                new QueryWrapper<FlowLogicModelData>()
                        .eq(StringUtils.isNotBlank(param.getTenantId()), "tenant_id", param.getTenantId())
                        .eq(StringUtils.isNotBlank(param.getBusinessCode()), "business_code", param.getBusinessCode())
                        .eq(StringUtils.isNotBlank(param.getExt1()), "ext1", param.getExt1())
                        .eq(StringUtils.isNotBlank(param.getExt2()), "ext2", param.getExt2())
                        .eq(StringUtils.isNotBlank(param.getExt3()), "ext3", param.getExt3())
                        .eq(Constant.IS_VALID, Constant.IS_VALIDED)
        );
        return new PageUtils(page);
    }

    @Override
    public boolean logicDelete(String id) {
        return this.update(new UpdateWrapper<FlowLogicModelData>()
                .set(Constant.IS_VALID, Constant.IS_NOT_VALIDED)
                .eq("id", id));
    }
}
