package com.xforceplus.janus.flow.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.commons.util.DateUtils;
import com.xforceplus.janus.flow.sys.dao.FsNodeDao;
import com.xforceplus.janus.flow.sys.entity.NodeEntity;
import com.xforceplus.janus.flow.sys.service.NodeService;
import com.xforceplus.janus.flow.sys.util.Constant;

import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: gateway-ops->DataFlowNodeServiceImpl
 * @description:
 * @author: xuchuanhou
 * @create: 2020-06-06 17:36
 **/
@Service("fsNodeService")
public class FsNodeServiceImpl extends ServiceImpl<FsNodeDao, NodeEntity> implements NodeService {


    @Override
    public boolean saveOrUpdateBatchNode(List<NodeEntity> nodes) {

        List<String> nodeIds = nodes.stream().map(node -> node.getId()).collect(Collectors.toList());
        this.update(new UpdateWrapper<NodeEntity>()
                .set(Constant.IS_VALID, Constant.IS_NOT_VALIDED)
                .notIn("id", nodeIds)
                .eq("flow_Id", nodes.get(0).getFlowId()));

        return this.saveOrUpdateBatch(nodes);
    }

    @Override
    public List<NodeEntity> listByFlowId(String flowId) {
        return
                this.list(new QueryWrapper<NodeEntity>()
                        .eq("flow_Id", flowId)
                        .eq(Constant.IS_VALID, Constant.IS_VALIDED));
    }

    @Override
    public List<NodeEntity> listRichByFlowId(String flowId) {
        List<NodeEntity> nodeList = listByFlowId(flowId);

        if (nodeList == null) {
            return null;
        }
//        List<NodeConfigEntity> nodeConfigs = nodeConfigService.listByFlowId(flowId);
//        if (CollectionUtils.isNotEmpty(nodeConfigs)) {
//
//            Map<String, List<NodeConfigEntity>> nodeConfigMap =
//                    nodeConfigs.parallelStream().collect(Collectors.groupingBy(config -> config.getNodeId()));
//            nodeList.forEach(node -> node.setNodeConfigs(nodeConfigMap.get(node.getId())));
//        }
        return nodeList;
    }

    @Override
    public boolean deleteByFlowId(String flowId) {
        String curTime = DateUtils.format(new Date(), DateUtils.DATE_TIME_PATTERN);
        return this.update(new UpdateWrapper<NodeEntity>()
                .set(Constant.IS_VALID, Constant.IS_NOT_VALIDED)
                .set("modified_time", curTime)
                .eq("flow_id", flowId));
    }
}
