package com.xforceplus.janus.flow.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.xforceplus.janus.commons.util.DateUtils;
import com.xforceplus.janus.commons.util.UniqIdUtils;
import com.xforceplus.janus.flow.core.minitor.CompStatistics;

import java.util.Date;

import lombok.Data;

/**
 * 节点
 */
@Data
@TableName("t_janus_flow_log")
public class FlowInstanceLog {
    private String id;
    private String flowId;

    /**
     * 流程执行记录实例ID(requestId)
     */
    private String instanceId;
    private String nodeType;
    private String nodeId;

    @TableField("startTime")
    private long startTime;
    @TableField("timeSpent")
    private long timeSpent;
    @TableField("errMsg")
    private String errMsg;

    public static FlowInstanceLog convertFromDto(CompStatistics statistics) {
        FlowInstanceLog nodeLog = new FlowInstanceLog();
        nodeLog.setId(UniqIdUtils.getInstance().getUniqID());
        nodeLog.setNodeId(statistics.getNodeId());
        nodeLog.setFlowId(statistics.getFlowId());
        nodeLog.setNodeType(statistics.getNodeType());
        nodeLog.setInstanceId(statistics.getFlowInstanceId());
        nodeLog.setTimeSpent(statistics.getTimeSpent());
        nodeLog.setErrMsg(statistics.getErrMsg());
        nodeLog.setStartTime(statistics.getStartTime());
        return nodeLog;
    }

}
