package com.xforceplus.janus.flow.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.janus.commons.dto.BaseEntity;
import com.xforceplus.janus.flow.core.enums.NodeTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

/**
 * @program: janus-flow->FlowNode
 * @description: 流程节点表
 * @author: xuchuanhou
 * @create: 2020-06-06 15:11
 **/

@TableName("t_janus_flow_node")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class NodeEntity extends BaseEntity {

    private String flowId;

    @NotBlank(message = "节点名称不能为空")
    private String nodeName;

    @NotBlank(message = "节点类型不能为空")
    private String nodeType;

    private String location;

    private String color;

    private String figure;

    /** 节点拓展属性配置 */
    @TableField(exist = false)
    private List<NodeConfigEntity> nodeConfigs;

    /** 接收前台数据 */
    @TableField(exist = false)
    private Map<String, Object> extendDtoPropeties;

    @TableField(exist = false)
    private String key;

    //TODO 转换到VO 需要设置为空
    private String nodeConfig;


//    public NodeTypeEnum getNodeTypeEnum() {
//        return NodeTypeEnum.getByCode(this.nodeType);
//    }
}
