package com.xforceplus.janus.flow.sys.service;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import com.xforceplus.janus.commons.dto.R;
import com.xforceplus.janus.flow.sys.entity.FlowEntity;
import com.xforceplus.janus.flow.sys.param.FlowQueryParam;

/**
 * @program: gateway-ops->DataFlowService
 * @description:
 * @author: xuchuanhou
 * @create: 2020-06-06 17:30
 **/
public interface FlowService extends IService<FlowEntity> {

    R saveDataFlow(FlowEntity dataFlow) throws Exception;

    FlowEntity richDataByBoundApiId(String boundApi);

    FlowEntity richDataByBoundAction(String boundAction);

    FlowEntity richDataById(String flowId);

    FlowEntity findByApiId(String projectId, String apiId);
    FlowEntity findByAction( String action,String type);

    FlowEntity findOneFlow(String projectId,String action, String api, String type);

//    R reloadFlowBus(FlowEntity dataFlow);

    List<FlowEntity> findAll();

    List<FlowEntity> findSimpleFlow(String status);

    R publishFlow(String flowId);
    R unPublishFlow(String flowId);

    List<FlowEntity> find(FlowQueryParam param);

    boolean deleteById(String flowId);

}
