package com.xforceplus.janus.flow.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.commons.util.PageUtils;
import com.xforceplus.janus.dbs.common.Query;
import com.xforceplus.janus.flow.sys.dao.BusinessLogicDefineDao;
import com.xforceplus.janus.flow.sys.entity.BusinessLogicDefine;
import com.xforceplus.janus.flow.sys.param.LogicDefinePageParam;
import com.xforceplus.janus.flow.sys.service.BusinessLogicDefineService;
import com.xforceplus.janus.flow.sys.util.Constant;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BusinessLogicDefineServiceImpl extends ServiceImpl<BusinessLogicDefineDao, BusinessLogicDefine> implements BusinessLogicDefineService {

    @Override
    public PageUtils queryPage(LogicDefinePageParam param) {
        IPage<BusinessLogicDefine> page = this.page(new Query<BusinessLogicDefine>().getPage(param),
                new QueryWrapper<BusinessLogicDefine>()
                        .like(StringUtils.isNotBlank(param.getName()), "name", param.getName())
                        .eq(StringUtils.isNotBlank(param.getCode()), "code", param.getCode())
                        .eq(Constant.IS_VALID, Constant.IS_VALIDED)
        );
        return new PageUtils(page);
    }

    @Override
    public boolean logicDelete(String id) {
        return this.update(new UpdateWrapper<BusinessLogicDefine>()
                .set(Constant.IS_VALID, Constant.IS_NOT_VALIDED)
                .eq("id", id));
    }

    @Override
    public BusinessLogicDefine queryByCode(String code) {
        BusinessLogicDefine logicDefine = this.getOne(new QueryWrapper<BusinessLogicDefine>()
                .eq("code", code)
                .eq(Constant.IS_VALID, Constant.IS_VALIDED)
        );
        return logicDefine;
    }

    @Override
    public List<BusinessLogicDefine> queryAll() {
       return  this.list(new QueryWrapper<BusinessLogicDefine>()
                .eq(Constant.IS_VALID, Constant.IS_VALIDED)
        );
    }
}
