package com.xforceplus.janus.flow.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.flow.sys.dao.ExecutorLogDao;
import com.xforceplus.janus.flow.sys.entity.FlowInstanceLog;
import com.xforceplus.janus.flow.sys.service.ExecutorLogService;

import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ExecutorLogServiceImpl extends ServiceImpl<ExecutorLogDao, FlowInstanceLog> implements ExecutorLogService {

    @Override
    public List<FlowInstanceLog> trackByInstanceId(String instanceId) {

        return this.list(new QueryWrapper<FlowInstanceLog>()
                .select("instance_id","node_type","node_id","startTime","timeSpent")
                .eq("instance_id",instanceId)
                .orderByAsc("startTime"));
    }



}
