package com.xforceplus.janus.flow.sys.service.impl;

import java.util.Date;
import java.util.List;

import com.xforceplus.janus.commons.util.DateUtils;
import com.xforceplus.janus.flow.sys.dao.FsNodeMappingDao;
import com.xforceplus.janus.flow.sys.entity.NodeMappingEntity;
import com.xforceplus.janus.flow.sys.service.NodeMappingService;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.flow.sys.util.Constant;

/**
 * @program: gateway-ops->NodeMappingServiceImpl
 * @description:
 * @author: xuchuanhou
 * @create: 2020-06-06 17:37
 **/
@Service("fsNodeMappingService")
public class FsNodeMappingServiceImpl extends ServiceImpl<FsNodeMappingDao, NodeMappingEntity>
    implements NodeMappingService {

    @Override
    public List<NodeMappingEntity> ListRichByFlowId(String flowId) {
        return this.list(
            new QueryWrapper<NodeMappingEntity>().eq("flow_Id", flowId).eq(Constant.IS_VALID, Constant.IS_VALIDED));
    }

    @Override
    public boolean deleteLogicByFlowId(String flowId) {
        String curTime= DateUtils.format(new Date(),DateUtils.DATE_TIME_PATTERN);
        return this.update(new UpdateWrapper<NodeMappingEntity>()
                .set(Constant.IS_VALID, Constant.IS_NOT_VALIDED)
                .set("modified_time",curTime)
            .eq("flow_Id", flowId));
    }
}
