/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.flow.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.dto.BaseEntity;
import com.xforceplus.janus.commons.util.UniqIdUtils;
import com.xforceplus.janus.flow.core.entity.Flow;
import com.xforceplus.janus.flow.core.entity.Node;
import com.xforceplus.janus.flow.core.entity.dto.NodeConfigApiDto;
import com.xforceplus.janus.flow.core.entity.dto.NodeConfigBranchDto;
import com.xforceplus.janus.flow.core.entity.dto.NodeConfigCmplDto;
import com.xforceplus.janus.flow.core.entity.dto.NodeConfigConcatDto;
import com.xforceplus.janus.flow.core.entity.dto.NodeConfigEtlDto;
import com.xforceplus.janus.flow.core.entity.dto.NodeConfigExtractDto;
import com.xforceplus.janus.flow.core.entity.dto.NodeConfigStartDto;
import com.xforceplus.janus.flow.core.enums.NodeTypeEnum;
import com.xforceplus.janus.flow.logic.model.FieldMappingDto;
import com.xforceplus.janus.flow.sys.entity.NodeConfigEntity;
import com.xforceplus.janus.flow.sys.entity.NodeEntity;
import com.xforceplus.janus.flow.sys.entity.NodeMappingEntity;
import com.xforceplus.janus.flow.sys.entity.vo.BranchConditVO;
import com.xforceplus.janus.flow.sys.exception.NodeNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

@TableName(value="t_janus_flow")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FlowEntity
extends BaseEntity {
    public static final String STATUS_INIT = "1";
    public static final String STATUS_PUBLISH = "2";
    public static final String TYPE_FLOW_ACTION = "1";
    public static final String TYPE_FLOW_API = "2";
    public static final String TYPE_DATA_LINK_API = "3";
    public static final String TYPE_DATA_LINK_ACTION = "4";
    public static final String TYPE_FLOW_LOCAL = "5";
    public static final String TYPE_FLOW_LOCAL_HTTP = "6";
    public static final String TYPE_FLOW_LOCAL_TASK = "7";
    public static final String TYPE_FLOW_LOCAL_MQ = "8";
    @NotBlank(message="\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String projectId;
    private String name;
    @TableField(exist=false)
    private String version;
    private String boundApi;
    private String boundAction;
    private String status = "1";
    private String type = "1";
    @Valid
    @NotNull(message="\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a")
    @TableField(exist=false)
    private @Valid @NotNull(message="\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a") List<NodeEntity> nodeDataArray;
    @NotNull(message="\u8282\u70b9\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a")
    @TableField(exist=false)
    private @NotNull(message="\u8282\u70b9\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a") List<NodeMappingEntity> linkDataArray;
    private String cron;
    private String config;

    public void fromVo2Entity() {
        if (CollectionUtils.isEmpty(this.nodeDataArray)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.getId())) {
            this.setId(UniqIdUtils.getInstance().getUniqID());
        }
        HashMap<String, NodeEntity> succNodeMap = new HashMap<String, NodeEntity>();
        for (NodeEntity node : this.nodeDataArray) {
            if (StringUtils.isBlank((CharSequence)node.getId()) && StringUtils.isNotBlank((CharSequence)node.getKey())) {
                node.setId(UniqIdUtils.getInstance().getUniqID());
            }
            node.setFlowId(this.getId());
        }
        for (NodeEntity node : this.nodeDataArray) {
            for (NodeMappingEntity nodeMapping : this.linkDataArray) {
                if (StringUtils.isBlank((CharSequence)nodeMapping.getLastNodeId()) && nodeMapping.getFrom().equals(node.getKey())) {
                    nodeMapping.setLastNodeId(node.getId());
                }
                if (StringUtils.isBlank((CharSequence)nodeMapping.getNextNodeId()) && nodeMapping.getTo().equals(node.getKey())) {
                    nodeMapping.setNextNodeId(node.getId());
                }
                nodeMapping.setFlowId(this.getId());
                if (!node.getId().equals(nodeMapping.getNextNodeId()) && !node.getId().equals(nodeMapping.getLastNodeId())) continue;
                succNodeMap.put(node.getId(), node);
            }
            if (!MapUtils.isNotEmpty(node.getExtendDtoPropeties())) continue;
            ArrayList<NodeConfigEntity> nodeConfigs = new ArrayList<NodeConfigEntity>(node.getExtendDtoPropeties().size());
            node.setNodeConfigs(nodeConfigs);
            NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getByCode((String)node.getNodeType());
            switch (nodeTypeEnum) {
                case BRANCH: {
                    List branchConfigs = JacksonUtil.getInstance().fromJsonToList(JacksonUtil.getInstance().toJson(node.getExtendDtoPropeties().get("branchs")), BranchConditVO.class);
                    for (BranchConditVO branchConfig : branchConfigs) {
                        NodeEntity nextNode = this.findByNodeKey(branchConfig.getNextNodeKey());
                        if (nextNode == null) {
                            throw new NodeNotFoundException(branchConfig.getNextNodeKey() + "\u4e0b\u4e2a\u8282\u70b9\u672a\u627e\u5230");
                        }
                        branchConfig.setNextNodeId(nextNode.getId());
                        branchConfig.setNextNodeKey(nextNode.getId());
                    }
                    node.getExtendDtoPropeties().put("branchs", branchConfigs);
                    break;
                }
            }
            node.setNodeConfig(JacksonUtil.getInstance().toJson(node.getExtendDtoPropeties()));
        }
        this.nodeDataArray = new ArrayList(succNodeMap.values());
    }

    private NodeEntity findByNodeKey(String key) {
        for (NodeEntity node : this.nodeDataArray) {
            if (!node.getKey().equals(key)) continue;
            return node;
        }
        return null;
    }

    private String getNextNodeId(NodeEntity nodeEntity) {
        if (NodeTypeEnum.BRANCH.getCode().equals(nodeEntity.getNodeType())) {
            return null;
        }
        for (NodeMappingEntity nodeMap : this.linkDataArray) {
            if (!nodeMap.getLastNodeId().equals(nodeEntity.getId())) continue;
            return nodeMap.getNextNodeId();
        }
        return null;
    }

    public void fromEntity2Vo() {
        for (NodeEntity node : this.nodeDataArray) {
            node.setKey(node.getId());
            if (StringUtils.isNotBlank((CharSequence)node.getNodeConfig())) {
                node.setExtendDtoPropeties((Map)JacksonUtil.getInstance().fromJson(node.getNodeConfig(), Map.class));
            }
            node.setNodeConfig(null);
            node.setNodeConfigs(null);
        }
        for (NodeMappingEntity nodeMapping : this.linkDataArray) {
            nodeMapping.setFrom(nodeMapping.getLastNodeId());
            nodeMapping.setTo(nodeMapping.getNextNodeId());
        }
    }

    public Flow fromEntity2Dto() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (NodeEntity nodeEntity : this.nodeDataArray) {
            NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getByCode((String)nodeEntity.getNodeType());
            HashMap<String, Object> nodeConfigMap = this.getNodeProperties(nodeEntity);
            Node node = null;
            switch (nodeTypeEnum) {
                case START: {
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    node.setConfig((Object)new NodeConfigStartDto());
                    break;
                }
                case API: {
                    NodeConfigApiDto apiDto = (NodeConfigApiDto)JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(nodeConfigMap), NodeConfigApiDto.class);
                    if (apiDto.getApiRetryDto() != null && apiDto.getApiRetryDto().getRetryTimes() == null) {
                        apiDto.getApiRetryDto().setRetryTimes(Integer.valueOf(1));
                        apiDto.getApiRetryDto().setInterval(Long.valueOf(1000L));
                    }
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    if (StringUtils.isNotBlank((CharSequence)apiDto.getAction())) {
                        if (apiDto.getHeaderKeys() == null) {
                            apiDto.setHeaderKeys(new ArrayList());
                        }
                        apiDto.getHeaderKeys().add(new FieldMappingDto("action", null, apiDto.getAction()));
                        apiDto.getHeaderKeys().add(new FieldMappingDto("Authentication", null, apiDto.getAuthentication()));
                        apiDto.getHeaderKeys().add(new FieldMappingDto("rpcType", null, "http"));
                        if (StringUtils.isNotBlank((CharSequence)apiDto.getUiaSign())) {
                            apiDto.getHeaderKeys().add(new FieldMappingDto("uiaSign", null, apiDto.getUiaSign()));
                        }
                    }
                    node.setConfig((Object)apiDto);
                    break;
                }
                case CMPL: {
                    NodeConfigCmplDto cmplDto = (NodeConfigCmplDto)JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(nodeConfigMap), NodeConfigCmplDto.class);
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    node.setConfig((Object)cmplDto);
                    break;
                }
                case TRANSFORM: {
                    NodeConfigEtlDto etDto = (NodeConfigEtlDto)JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(nodeConfigMap), NodeConfigEtlDto.class);
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    node.setConfig((Object)etDto);
                    break;
                }
                case EXTRACT: {
                    NodeConfigExtractDto extractDto = (NodeConfigExtractDto)JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(nodeConfigMap), NodeConfigExtractDto.class);
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    node.setConfig((Object)extractDto);
                    break;
                }
                case BRANCH: {
                    if (!MapUtils.isNotEmpty(nodeConfigMap)) break;
                    NodeConfigBranchDto branchDto = (NodeConfigBranchDto)JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(nodeConfigMap), NodeConfigBranchDto.class);
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    node.setConfig((Object)branchDto);
                    break;
                }
                case BUILD_PARAM: {
                    NodeConfigConcatDto concatDto = (NodeConfigConcatDto)JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(nodeConfigMap), NodeConfigConcatDto.class);
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    node.setConfig((Object)concatDto);
                    break;
                }
                default: {
                    node = new Node(nodeEntity.getId(), this.getId(), nodeEntity.getNodeName(), nodeEntity.getNodeType());
                    node.setConfig(nodeConfigMap);
                }
            }
            node.setNextNodeId(this.getNextNodeId(nodeEntity));
            nodes.add(node);
        }
        Flow flow = new Flow(this.getId(), this.getName(), nodes);
        flow.setConfig(this.getConfig());
        flow.setType(this.getType());
        return flow;
    }

    private HashMap<String, Object> getNodeProperties(NodeEntity nodeEntity) {
        HashMap nodeConfigMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)nodeEntity.getNodeConfig())) {
            nodeConfigMap = (HashMap)JacksonUtil.getInstance().fromJson(nodeEntity.getNodeConfig(), HashMap.class);
            return nodeConfigMap;
        }
        return nodeConfigMap;
    }

    public List<NodeEntity> sortNode() {
        ArrayList<NodeEntity> sortedNodeList = new ArrayList<NodeEntity>();
        Map nodeIdMap = this.nodeDataArray.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (v1, v2) -> v1));
        NodeMappingEntity rootMap = FlowEntity.getRootNode(this.linkDataArray);
        sortedNodeList.add((NodeEntity)((Object)nodeIdMap.get(rootMap.getLastNodeId())));
        sortedNodeList.add((NodeEntity)((Object)nodeIdMap.get(rootMap.getNextNodeId())));
        while ((rootMap = FlowEntity.getNextNodeMap(rootMap, this.linkDataArray)) != null) {
            sortedNodeList.add((NodeEntity)((Object)nodeIdMap.get(rootMap.getNextNodeId())));
        }
        return sortedNodeList;
    }

    private static NodeMappingEntity getRootNode(List<NodeMappingEntity> nmList) {
        NodeMappingEntity root = null;
        for (int i = 0; i < nmList.size(); ++i) {
            if (i == 0) {
                root = nmList.get(0);
                continue;
            }
            if (!nmList.get(i).getNextNodeId().equals(root.getLastNodeId())) continue;
            root = nmList.get(i);
        }
        return root;
    }

    private static NodeMappingEntity getNextNodeMap(NodeMappingEntity lastNM, List<NodeMappingEntity> nmList) {
        for (NodeMappingEntity nm : nmList) {
            if (!nm.getLastNodeId().equals(lastNM.getNextNodeId())) continue;
            return nm;
        }
        return null;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBoundApi() {
        return this.boundApi;
    }

    public String getBoundAction() {
        return this.boundAction;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public List<NodeEntity> getNodeDataArray() {
        return this.nodeDataArray;
    }

    public List<NodeMappingEntity> getLinkDataArray() {
        return this.linkDataArray;
    }

    public String getCron() {
        return this.cron;
    }

    public String getConfig() {
        return this.config;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBoundApi(String boundApi) {
        this.boundApi = boundApi;
    }

    public void setBoundAction(String boundAction) {
        this.boundAction = boundAction;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setNodeDataArray(List<NodeEntity> nodeDataArray) {
        this.nodeDataArray = nodeDataArray;
    }

    public void setLinkDataArray(List<NodeMappingEntity> linkDataArray) {
        this.linkDataArray = linkDataArray;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowEntity)) {
            return false;
        }
        FlowEntity other = (FlowEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$boundApi = this.getBoundApi();
        String other$boundApi = other.getBoundApi();
        if (this$boundApi == null ? other$boundApi != null : !this$boundApi.equals(other$boundApi)) {
            return false;
        }
        String this$boundAction = this.getBoundAction();
        String other$boundAction = other.getBoundAction();
        if (this$boundAction == null ? other$boundAction != null : !this$boundAction.equals(other$boundAction)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<NodeEntity> this$nodeDataArray = this.getNodeDataArray();
        List<NodeEntity> other$nodeDataArray = other.getNodeDataArray();
        if (this$nodeDataArray == null ? other$nodeDataArray != null : !((Object)this$nodeDataArray).equals(other$nodeDataArray)) {
            return false;
        }
        List<NodeMappingEntity> this$linkDataArray = this.getLinkDataArray();
        List<NodeMappingEntity> other$linkDataArray = other.getLinkDataArray();
        if (this$linkDataArray == null ? other$linkDataArray != null : !((Object)this$linkDataArray).equals(other$linkDataArray)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        String this$config = this.getConfig();
        String other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $boundApi = this.getBoundApi();
        result = result * 59 + ($boundApi == null ? 43 : $boundApi.hashCode());
        String $boundAction = this.getBoundAction();
        result = result * 59 + ($boundAction == null ? 43 : $boundAction.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<NodeEntity> $nodeDataArray = this.getNodeDataArray();
        result = result * 59 + ($nodeDataArray == null ? 43 : ((Object)$nodeDataArray).hashCode());
        List<NodeMappingEntity> $linkDataArray = this.getLinkDataArray();
        result = result * 59 + ($linkDataArray == null ? 43 : ((Object)$linkDataArray).hashCode());
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        String $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "FlowEntity(projectId=" + this.getProjectId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", boundApi=" + this.getBoundApi() + ", boundAction=" + this.getBoundAction() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", nodeDataArray=" + this.getNodeDataArray() + ", linkDataArray=" + this.getLinkDataArray() + ", cron=" + this.getCron() + ", config=" + this.getConfig() + ")";
    }
}

