/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.flow.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.commons.dto.R;
import com.xforceplus.janus.commons.exception.RRException;
import com.xforceplus.janus.commons.util.DateUtils;
import com.xforceplus.janus.commons.validator.ValidatorUtils;
import com.xforceplus.janus.flow.sys.dao.FsFlowEntityDao;
import com.xforceplus.janus.flow.sys.entity.FlowEntity;
import com.xforceplus.janus.flow.sys.entity.NodeMappingEntity;
import com.xforceplus.janus.flow.sys.param.FlowQueryParam;
import com.xforceplus.janus.flow.sys.service.FlowService;
import com.xforceplus.janus.flow.sys.service.NodeMappingService;
import com.xforceplus.janus.flow.sys.service.NodeService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="flowServerService")
@CacheConfig(cacheNames={"flow"})
public class FsFlowServiceImpl
extends ServiceImpl<FsFlowEntityDao, FlowEntity>
implements FlowService {
    private static final Logger log = LoggerFactory.getLogger(FsFlowServiceImpl.class);
    @Autowired
    private NodeService nodeService;
    @Autowired
    private NodeMappingService nodeMappingService;

    @Override
    @Transactional
    public R saveDataFlow(FlowEntity dataFlow) throws Exception {
        dataFlow.fromVo2Entity();
        ValidatorUtils.validateEntity((Object)((Object)dataFlow), (Class[])new Class[0]);
        if (!"7".equals(dataFlow.getType()) && !"8".equals(dataFlow.getType()) && StringUtils.isBlank((CharSequence)dataFlow.getBoundAction()) && StringUtils.isBlank((CharSequence)dataFlow.getBoundApi())) {
            throw new RRException("\u7ed1\u5b9a\u63a5\u53e3\u6216\u8005\u6388\u6743action\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        FlowEntity existDataFlow = null;
        if (StringUtils.isNotBlank((CharSequence)dataFlow.getBoundAction())) {
            existDataFlow = this.findByAction(dataFlow.getBoundAction(), dataFlow.getType());
        }
        if (existDataFlow == null && StringUtils.isNotBlank((CharSequence)dataFlow.getBoundApi())) {
            existDataFlow = this.findOneFlow(dataFlow.getProjectId(), null, dataFlow.getBoundApi(), dataFlow.getType());
        }
        if (existDataFlow != null && !existDataFlow.getId().equals(dataFlow.getId())) {
            return R.error((String)"action\u670d\u52a1\u7f16\u6392\u5df2\u7ecf\u5b58\u5728!");
        }
        this.saveOrUpdate((Object)dataFlow);
        this.nodeService.saveOrUpdateBatchNode(dataFlow.getNodeDataArray());
        this.nodeMappingService.deleteLogicByFlowId(dataFlow.getId());
        if (CollectionUtils.isNotEmpty(dataFlow.getLinkDataArray())) {
            this.nodeMappingService.saveOrUpdateBatch(dataFlow.getLinkDataArray());
        }
        return R.ok();
    }

    @Override
    public FlowEntity richDataByBoundApiId(String boundApi) {
        FlowEntity dataFlow = this.findByBoundApiId(boundApi, null);
        if (dataFlow == null) {
            return null;
        }
        this.extendFlow(dataFlow);
        return dataFlow;
    }

    private void extendFlow(FlowEntity dataFlow) {
        dataFlow.setNodeDataArray(this.nodeService.listRichByFlowId(dataFlow.getId()));
        if (CollectionUtils.isNotEmpty(dataFlow.getNodeDataArray())) {
            List<NodeMappingEntity> nodeMappingEntities = this.nodeMappingService.ListRichByFlowId(dataFlow.getId());
            List ids = dataFlow.getNodeDataArray().stream().map(map -> map.getId()).collect(Collectors.toList());
            List<NodeMappingEntity> nodeMapList = nodeMappingEntities.stream().filter(nodeMap -> {
                if (StringUtils.isNotBlank((CharSequence)nodeMap.getNextNodeId()) && !ids.contains(nodeMap.getNextNodeId())) {
                    return false;
                }
                return !StringUtils.isNotBlank((CharSequence)nodeMap.getLastNodeId()) || ids.contains(nodeMap.getLastNodeId());
            }).collect(Collectors.toList());
            dataFlow.setLinkDataArray(nodeMapList);
        }
    }

    @Override
    public FlowEntity richDataByBoundAction(String boundAction) {
        FlowEntity dataFlow = this.findByAction(boundAction, null);
        if (dataFlow == null) {
            return null;
        }
        this.extendFlow(dataFlow);
        return dataFlow;
    }

    @Override
    public FlowEntity richDataById(String flowId) {
        FlowEntity dataFlow = (FlowEntity)((Object)this.getById((Serializable)((Object)flowId)));
        if (dataFlow == null) {
            return null;
        }
        this.extendFlow(dataFlow);
        return dataFlow;
    }

    private FlowEntity findByBoundApiId(String apiId, String type) {
        return (FlowEntity)((Object)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bound_api", (Object)apiId)).eq(StringUtils.isNotBlank((CharSequence)type), (Object)"type", (Object)type)).eq((Object)"is_valid", (Object)1)));
    }

    @Override
    public FlowEntity findByAction(String action, String type) {
        FlowEntity flowEntity = (FlowEntity)((Object)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bound_action", (Object)action)).eq(StringUtils.isNotBlank((CharSequence)type), (Object)"type", (Object)type)).eq((Object)"is_valid", (Object)1)));
        return flowEntity;
    }

    @Override
    public FlowEntity findByApiId(String projectId, String apiId) {
        return (FlowEntity)((Object)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bound_api", (Object)apiId)).eq((Object)"project_id", (Object)projectId)).eq((Object)"is_valid", (Object)1)));
    }

    @Override
    public List<FlowEntity> findAll() {
        List flowList = this.list((Wrapper)new QueryWrapper().eq((Object)"is_valid", (Object)1));
        if (CollectionUtils.isEmpty((Collection)flowList)) {
            return null;
        }
        flowList.forEach(flowEntity -> {
            flowEntity.setNodeDataArray(this.nodeService.listRichByFlowId(flowEntity.getId()));
            flowEntity.setLinkDataArray(this.nodeMappingService.ListRichByFlowId(flowEntity.getId()));
        });
        return flowList;
    }

    @Override
    public List<FlowEntity> findSimpleFlow(String status) {
        List flowList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_valid", (Object)1)).eq(StringUtils.isNotBlank((CharSequence)status), (Object)"status", (Object)"2"));
        return flowList;
    }

    @Override
    public R publishFlow(String flowId) {
        FlowEntity flowEntity = new FlowEntity();
        flowEntity.setId(flowId);
        flowEntity.setStatus("2");
        this.updateById((Object)flowEntity);
        return R.ok();
    }

    @Override
    public FlowEntity findOneFlow(String projectId, String action, String api, String type) {
        return (FlowEntity)((Object)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(StringUtils.isNotBlank((CharSequence)projectId), (Object)"project_id", (Object)projectId)).eq(StringUtils.isNotBlank((CharSequence)api), (Object)"bound_api", (Object)api)).eq(StringUtils.isNotBlank((CharSequence)action), (Object)"bound_action", (Object)action)).eq(StringUtils.isNotBlank((CharSequence)type), (Object)"type", (Object)type)).eq((Object)"is_valid", (Object)1)));
    }

    @Override
    public R unPublishFlow(String flowId) {
        FlowEntity flowEntity = new FlowEntity();
        flowEntity.setId(flowId);
        flowEntity.setStatus("1");
        this.updateById((Object)flowEntity);
        return R.ok();
    }

    @Override
    public List<FlowEntity> find(FlowQueryParam param) {
        return this.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(StringUtils.isNotBlank((CharSequence)param.getProjectId()), (Object)"project_id", (Object)param.getProjectId())).eq(StringUtils.isNotBlank((CharSequence)param.getApiId()), (Object)"bound_api", (Object)param.getApiId())).eq(StringUtils.isNotBlank((CharSequence)param.getAction()), (Object)"bound_action", (Object)param.getAction())).eq(StringUtils.isNotBlank((CharSequence)param.getType()), (Object)"type", (Object)param.getType())).eq(StringUtils.isNotBlank((CharSequence)param.getStatus()), (Object)"status", (Object)param.getStatus())).in(CollectionUtils.isNotEmpty(param.getTypes()), (Object)"type", param.getTypes())).eq((Object)"is_valid", (Object)1));
    }

    @Override
    @Transactional
    public boolean deleteById(String flowId) {
        FlowEntity flow = (FlowEntity)((Object)this.getById((Serializable)((Object)flowId)));
        if (flow == null) {
            return true;
        }
        String curTime = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        flow.setIsValid(0);
        flow.setModifiedTime(curTime);
        this.updateById((Object)flow);
        this.nodeService.deleteByFlowId(flowId);
        this.nodeMappingService.deleteLogicByFlowId(flowId);
        return true;
    }
}

