package com.xforceplus.janus.config.core.config;

import com.xforceplus.janus.config.core.dto.ProjectDto;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2021/12/29上午10:47
 */

@Data
public class HttpConfig {
    //    private String fetchConfigAction;
    private String authentication;

    /**
     * 上传属地配置到云端接口Action
     */
//    private String uploadProjectInfoAction;

    private ActionConfig action = new ActionConfig();

    private WebFilterCofig webfilter = new WebFilterCofig();

    private AccessConfig access = new AccessConfig();

    private String url;

    private String clientId;
    private String tcpUrl;
    private int tcpPort;

    /**
     * 1:默认本地锁
     */
    private String lockType = "1";
    /**
     * schema 监控告警阈值
     */
    private Integer schemaMonitorSize;

    ProjectDto projectDto;

    private static Map<String, Object> CONFIGS = new ConcurrentHashMap<>();

    public static  <T> T getConfig(String key) {
        return (T)CONFIGS.get(key);
    }

    public <T> void setConfig(String key,T value) {
        CONFIGS.put(key,value);
    }

    private String version="1.2.1.12";


}
