package com.xforceplus.janus.config.core.monitor;

import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.param.MonitorParam;
import com.xforceplus.janus.config.core.util.Constant;


import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 系统监控信息上传
 *
 * @Author: xuchuanhou
 * @Date:2022/3/18下午6:37
 */
@Slf4j
@NoArgsConstructor
@AllArgsConstructor
public class JanusUploader {

    private HttpConfig httpConfig;

    public boolean uploadMonitor(MonitorParam param) {
        Map<String, String> headers = getHeaders();
        headers.put("action", httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", Constant.UPLOAD_TYPE_MONITORNOTICE);
        String body = JacksonUtil.getInstance().toJson(param);
        try {
            HttpUtil.ResponseCus responseCus = HttpUtil.doPostJsonEntire(httpConfig.getUrl(), body, headers,
                    null);
            log.warn(responseCus.getBody());
            return responseCus.getStatus() == 22;
        } catch (IOException ex) {
            log.error("监控信息上传异常:{}", body);
            return false;
        }
    }

    private Map<String, String> getHeaders() {
        Map<String, String> headers = new HashMap<>();
        headers.put("Authentication", httpConfig.getAuthentication());
        headers.put("rpcType", "http");
        headers.put(Constant.KEY_SERIALNO, "" + System.currentTimeMillis());
        return headers;
    }

    //向云端发送统计数据
    public boolean sendStatics(Map<String, Object> businessStaticsParam) {
        Map<String, String> headers = getHeaders();

        headers.put("action", httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", Constant.UPLOAD_TYPE_ACCEPTSTATICS);

        String json = JacksonUtil.getInstance().toJson(businessStaticsParam);
        try {
            HttpUtil.ResponseCus responseCus = HttpUtil.doPostJsonEntire(httpConfig.getUrl(), json, headers, null);
            log.info("url {}", httpConfig.getUrl());
            log.info("json {}", json);
            log.info("headers {}", JacksonUtil.getInstance().toJson(headers));
            return responseCus.getStatus() == 22;
        } catch (Exception e) {
            log.error("上传统计数据异常:{}", json);
            return false;
        }
    }

    //向集成平台云端推送
    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body) {
        return sendJanusCmdResult(sourceType, cmdSerialKey, body, null);
    }

    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body, String serialNo) {

        Map<String, String> headers = getHeaders();

        headers.put("action", httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", sourceType);
        headers.put("cmdSerialKey", cmdSerialKey);
        if (StringUtils.isNotBlank(serialNo)) {
            headers.put(Constant.KEY_SERIALNO, serialNo);
        }

        String json = JacksonUtil.getInstance().toJson(body);
        try {
            HttpUtil.ResponseCus responseCus = HttpUtil.doPostJsonEntire(httpConfig.getUrl(), json, headers, null);
            log.info("url {} headers {}", JacksonUtil.getInstance().toJson(headers), httpConfig.getUrl());
            log.info("json {}", json);
            return responseCus.getStatus() == 22;
        } catch (Exception e) {
            log.error("上传统计数据异常:{}", json);
            return false;
        }

    }

}
