package com.xforceplus.janus.config.core.util;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.xforceplus.apollo.jx.complex.ETHandle;
import com.xforceplus.apollo.jx.utils.JsonPathUtil;
import com.xforceplus.apollo.jx.utils.ShiftUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.dto.ETDateFormat;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/30下午3:57
 */
@Slf4j
public class ETUtil {
    /*字段日期格式化*/
    public static final String ETTYPE_DATE_FORMAT = "5";
    /*毫秒时间戳*/
    public static final String CUS_DATEFORMAT_TSMS = "timeStamp-ms";

    public static Configuration CONF_AS_PATH_LIST = Configuration.builder().options(Option.AS_PATH_LIST).build();

    public static String etConvert(String sourceJson, List<ETHandle> handleList, String businessKey) {

        String targetBody = sourceJson;
        if (sourceJson.startsWith("{\\\"")) {
            targetBody = StringEscapeUtils.unescapeJson(sourceJson);
        }

        for (ETHandle handle : handleList) {

            switch (handle.getEtType()) {
                case ETHandle.ETTYPE_SHIFT:
                    //JOLT 表达式
                    targetBody = ShiftUtil.shift(businessKey, targetBody, handle.getExpression());
                    break;
                case ETHandle.ETTYPE_MAP:
                    List<Map> configMapList = JacksonUtil.getInstance().fromJsonToList(handle.getExpression(), Map.class);

                    DocumentContext documentContext = JsonPath.parse(targetBody, CONF_AS_PATH_LIST);

                    JsonPathUtil.parse(targetBody);
                    for (Map<String, String> entry : configMapList) {
                        String sourceField = entry.get("key");
                        String targetField = entry.get("value");
                        if (StringUtils.isBlank(sourceField)) {
                            continue;
                        }
                        try {
                            String path = sourceField.substring(0, sourceField.lastIndexOf("."));
                            String val = sourceField.substring(sourceField.lastIndexOf(".") + 1);

                            List<String> pathList = documentContext.read(path);

                            if (CollectionUtils.isEmpty(pathList)) {
                                continue;
                            }

                            pathList.forEach(finalPath -> {

                                String fPath = finalPath.replaceAll("\\['", ".").replaceAll("'\\]", "");

                                if (StringUtils.isBlank(targetField)) {
                                    //新增字段值
                                    if (JsonPath.isPathDefinite(finalPath)) {
                                        JsonPathUtil.add(fPath, val);
                                    }
                                } else if (targetField.startsWith("$")) {
                                    //$xxx.val1 $yyyy.val2  如果$xxx下的值==val1 则$yyyy 路径下添加val2 TODO  针对数组存在问题
                                    String nowVal = JsonPathUtil.getJson(fPath);

                                    String addPath = targetField.substring(0, targetField.lastIndexOf("."));
                                    String addVal = targetField.substring(targetField.lastIndexOf(".") + 1);
                                    if (StringUtils.isNotBlank(nowVal) && nowVal.equalsIgnoreCase(val)) {
                                        JsonPathUtil.add(addPath, addVal);
                                    }
                                } else {
                                    //$xxx.val1 val2 将path下val1 替换成 val2
                                    String nowVal = JsonPathUtil.getJson(fPath);
                                    if (StringUtils.isNotBlank(nowVal) && nowVal.equalsIgnoreCase(val)) {
                                        JsonPathUtil.delete(fPath);
                                        JsonPathUtil.add(fPath, targetField);
                                    }
                                }
                            });
                        } catch (Exception ex) {
                            log.error("dictionay et error ,{},{}", sourceField, ex.getMessage());
                        }
                    }
                    targetBody = JsonPathUtil.getJson();
                    break;
                case ETTYPE_DATE_FORMAT:
                    if (StringUtils.isNotBlank(handle.getExpression())) {
                        List<ETDateFormat> etList = JacksonUtil.getInstance().fromJsonToList(handle.getExpression(), ETDateFormat.class);
                        DocumentContext etDfContext = JsonPath.parse(targetBody, CONF_AS_PATH_LIST);

                        JsonPathUtil.parse(targetBody);
                        for (ETDateFormat dateFormat : etList) {
                            //系统时间
                            if (ETDateFormat.SYSTEM_DATE.equals(dateFormat.getSourceField())) {
                                String etDate = DateFormatUtils.format(new Date(), dateFormat.getTargetFormat());
                                JsonPathUtil.add(dateFormat.getTargetField(), etDate);
                                continue;
                            }
                            if (StringUtils.isBlank(dateFormat.getSourceField())
                                    || StringUtils.isBlank(dateFormat.getSourceFormat())
                                    || StringUtils.isBlank(dateFormat.getTargetFormat())) {
                                continue;
                            }

                            /*支持多个*/
                            List<String> pathList = etDfContext.read(dateFormat.getSourceField());

                            if (CollectionUtils.isEmpty(pathList)) {
                                continue;
                            }

                            for (String finalPath : pathList) {
                                String fPath = finalPath.replaceAll("\\['", ".").replaceAll("'\\]", "");
                                String nowVal = JsonPathUtil.getJson(fPath);
                                if (StringUtils.isBlank(nowVal)) {
                                    continue;
                                }
                                try {
                                    Date dateTmp = null;
                                    if (CUS_DATEFORMAT_TSMS.equalsIgnoreCase(dateFormat.getSourceFormat())) {
                                        dateTmp = new Date(Long.parseLong(nowVal));
                                    } else {
                                        dateTmp = DateUtils.parseDate(nowVal, dateFormat.getSourceFormat());
                                    }

                                    String etDate = null;
                                    if (CUS_DATEFORMAT_TSMS.equalsIgnoreCase(dateFormat.getTargetFormat()) && dateTmp != null) {
                                        etDate = String.valueOf(dateTmp.getTime());
                                    } else {
                                        etDate = DateFormatUtils.format(dateTmp, dateFormat.getTargetFormat());
                                    }

                                    if (StringUtils.isBlank(dateFormat.getTargetField())) {
                                        JsonPathUtil.add(fPath, etDate);
                                    } else {
                                        JsonPathUtil.add(dateFormat.getTargetField(), etDate);
                                    }
                                } catch (Exception ex) {
                                    log.error("date format exception,path:{},sourceFormat:{},targetFormat,{}", fPath, dateFormat.getSourceFormat(), dateFormat.getTargetFormat(), ex.getMessage());
                                }
                            }
                        }

                        targetBody = JsonPathUtil.getJson();
                    }

                    break;
                default:
                    break;
            }
        }

        return targetBody;
    }
}