/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.util;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.xforceplus.apollo.jx.complex.ETHandle;
import com.xforceplus.apollo.jx.utils.JsonPathUtil;
import com.xforceplus.apollo.jx.utils.ShiftUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.dto.ETDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETUtil {
    private static final Logger log = LoggerFactory.getLogger(ETUtil.class);
    public static final String ETTYPE_DATE_FORMAT = "5";
    public static final String CUS_DATEFORMAT_TSMS = "timeStamp-ms";
    public static Configuration CONF_AS_PATH_LIST = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();

    public static String etConvert(String sourceJson, List<ETHandle> handleList, String businessKey) {
        String targetBody = sourceJson;
        if (sourceJson.startsWith("{\\\"")) {
            targetBody = StringEscapeUtils.unescapeJson((String)sourceJson);
        }
        for (ETHandle handle : handleList) {
            switch (handle.getEtType()) {
                case "2": {
                    targetBody = ShiftUtil.shift((String)businessKey, (String)targetBody, (String)handle.getExpression());
                    break;
                }
                case "4": {
                    List configMapList = JacksonUtil.getInstance().fromJsonToList(handle.getExpression(), Map.class);
                    DocumentContext documentContext = JsonPath.parse((String)targetBody, (Configuration)CONF_AS_PATH_LIST);
                    JsonPathUtil.parse((String)targetBody);
                    for (Map entry : configMapList) {
                        String sourceField = (String)entry.get("key");
                        String targetField = (String)entry.get("value");
                        if (StringUtils.isBlank((CharSequence)sourceField)) continue;
                        try {
                            String path = sourceField.substring(0, sourceField.lastIndexOf("."));
                            String val = sourceField.substring(sourceField.lastIndexOf(".") + 1);
                            List pathList = (List)documentContext.read(path, new Predicate[0]);
                            if (CollectionUtils.isEmpty((Collection)pathList)) continue;
                            pathList.forEach(finalPath -> {
                                String fPath = finalPath.replaceAll("\\['", ".").replaceAll("'\\]", "");
                                if (StringUtils.isBlank((CharSequence)targetField)) {
                                    if (JsonPath.isPathDefinite((String)finalPath)) {
                                        JsonPathUtil.add((String)fPath, (Object)val);
                                    }
                                } else if (targetField.startsWith("$")) {
                                    String nowVal = JsonPathUtil.getJson((String)fPath);
                                    String addPath = targetField.substring(0, targetField.lastIndexOf("."));
                                    String addVal = targetField.substring(targetField.lastIndexOf(".") + 1);
                                    if (StringUtils.isNotBlank((CharSequence)nowVal) && nowVal.equalsIgnoreCase(val)) {
                                        JsonPathUtil.add((String)addPath, (Object)addVal);
                                    }
                                } else {
                                    String nowVal = JsonPathUtil.getJson((String)fPath);
                                    if (StringUtils.isNotBlank((CharSequence)nowVal) && nowVal.equalsIgnoreCase(val)) {
                                        JsonPathUtil.delete((String)fPath);
                                        JsonPathUtil.add((String)fPath, (Object)targetField);
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            log.error("dictionay et error ,{},{}", (Object)sourceField, (Object)ex.getMessage());
                        }
                    }
                    targetBody = JsonPathUtil.getJson();
                    break;
                }
                case "5": {
                    if (!StringUtils.isNotBlank((CharSequence)handle.getExpression())) break;
                    List etList = JacksonUtil.getInstance().fromJsonToList(handle.getExpression(), ETDateFormat.class);
                    DocumentContext etDfContext = JsonPath.parse((String)targetBody, (Configuration)CONF_AS_PATH_LIST);
                    JsonPathUtil.parse((String)targetBody);
                    for (ETDateFormat dateFormat : etList) {
                        List pathList;
                        if ("system".equals(dateFormat.getSourceField())) {
                            String etDate = DateFormatUtils.format((Date)new Date(), (String)dateFormat.getTargetFormat());
                            JsonPathUtil.add((String)dateFormat.getTargetField(), (Object)etDate);
                            continue;
                        }
                        if (StringUtils.isBlank((CharSequence)dateFormat.getSourceField()) || StringUtils.isBlank((CharSequence)dateFormat.getSourceFormat()) || StringUtils.isBlank((CharSequence)dateFormat.getTargetFormat()) || CollectionUtils.isEmpty((Collection)(pathList = (List)etDfContext.read(dateFormat.getSourceField(), new Predicate[0])))) continue;
                        for (String finalPath2 : pathList) {
                            String fPath = finalPath2.replaceAll("\\['", ".").replaceAll("'\\]", "");
                            String nowVal = JsonPathUtil.getJson((String)fPath);
                            if (StringUtils.isBlank((CharSequence)nowVal)) continue;
                            try {
                                Date dateTmp = null;
                                dateTmp = CUS_DATEFORMAT_TSMS.equalsIgnoreCase(dateFormat.getSourceFormat()) ? new Date(Long.parseLong(nowVal)) : DateUtils.parseDate((String)nowVal, (String[])new String[]{dateFormat.getSourceFormat()});
                                String etDate = null;
                                etDate = CUS_DATEFORMAT_TSMS.equalsIgnoreCase(dateFormat.getTargetFormat()) && dateTmp != null ? String.valueOf(dateTmp.getTime()) : DateFormatUtils.format((Date)dateTmp, (String)dateFormat.getTargetFormat());
                                if (StringUtils.isBlank((CharSequence)dateFormat.getTargetField())) {
                                    JsonPathUtil.add((String)fPath, (Object)etDate);
                                    continue;
                                }
                                JsonPathUtil.add((String)dateFormat.getTargetField(), (Object)etDate);
                            }
                            catch (Exception ex) {
                                log.error("date format exception,path:{},sourceFormat:{},targetFormat,{}", new Object[]{fPath, dateFormat.getSourceFormat(), dateFormat.getTargetFormat(), ex.getMessage()});
                            }
                        }
                    }
                    targetBody = JsonPathUtil.getJson();
                    break;
                }
            }
        }
        return targetBody;
    }
}

