/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.condition;

import com.google.common.collect.Maps;
import com.xforceplus.apollo.condition.OperatorEnum;
import com.xforceplus.apollo.condition.judge.EqOperatorJudge;
import com.xforceplus.apollo.condition.judge.GTOperatorJudge;
import com.xforceplus.apollo.condition.judge.LTOperatorJudge;
import com.xforceplus.apollo.condition.judge.LikeOperatorJudge;
import com.xforceplus.apollo.condition.judge.MatchOperatorJudge;
import com.xforceplus.apollo.condition.judge.NotEqOperatorJudge;
import com.xforceplus.apollo.condition.judge.OperatorJudge;
import com.xforceplus.apollo.condition.judge.RegExOperatorJudge;
import com.xforceplus.apollo.zookeeper.model.Condition;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OperatorJudgeFactoryCus {
    private static final Map<String, OperatorJudge> OPERATOR_JUDGE_MAP = Maps.newHashMapWithExpectedSize((int)7);

    public static Boolean judge(Condition conditionZkDTO, String realData) {
        if (conditionZkDTO.getOperator() == OperatorEnum.NotEQ.getAlias()) {
            return Objects.isNull(conditionZkDTO) || StringUtils.isBlank((CharSequence)realData) ? true : OPERATOR_JUDGE_MAP.get(conditionZkDTO.getOperator()).judge(conditionZkDTO, realData);
        }
        return !Objects.isNull(conditionZkDTO) && !StringUtils.isBlank((CharSequence)realData) ? OPERATOR_JUDGE_MAP.get(conditionZkDTO.getOperator()).judge(conditionZkDTO, realData) : false;
    }

    static {
        OPERATOR_JUDGE_MAP.put(OperatorEnum.EQ.getAlias(), (OperatorJudge)new EqOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.MATCH.getAlias(), (OperatorJudge)new MatchOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.LIKE.getAlias(), (OperatorJudge)new LikeOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.REGEX.getAlias(), (OperatorJudge)new RegExOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.NotEQ.getAlias(), (OperatorJudge)new NotEqOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.GT.getAlias(), (OperatorJudge)new GTOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.LT.getAlias(), (OperatorJudge)new LTOperatorJudge());
    }
}

