/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.util;

import cn.hutool.core.util.IdUtil;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.jx.complex.ETHandle;
import com.xforceplus.apollo.jx.exchange.Json2Xml;
import com.xforceplus.apollo.jx.utils.JsonPathUtil;
import com.xforceplus.apollo.jx.utils.ShiftUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.dto.ETCreatePKDto;
import com.xforceplus.janus.config.core.dto.ETDateFormat;
import com.xforceplus.janus.config.core.dto.Json2XmlDto;
import com.xforceplus.janus.config.core.dto.Xml2JsonDto;
import com.xforceplus.janus.config.core.xml2json.XmlToJson;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETUtil {
    private static final Logger log = LoggerFactory.getLogger(ETUtil.class);
    public static final String ETTYPE_DATE_FORMAT = "5";
    public static final String ETTYPE_CREATE_PK = "6";
    public static final String CUS_DATEFORMAT_TSMS = "timeStamp-ms";
    public static Configuration CONF_AS_PATH_LIST = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();

    public static String etConvert(String sourceJson, List<ETHandle> handleList, String businessKey) {
        String targetBody = sourceJson;
        if (sourceJson.startsWith("{\\\"")) {
            targetBody = StringEscapeUtils.unescapeJson((String)sourceJson);
        }
        block36: for (ETHandle handle : handleList) {
            switch (handle.getEtType()) {
                case "0": {
                    if (!StringUtils.isNotBlank((CharSequence)handle.getExpression())) break;
                    Xml2JsonDto xml2JsonConfig = (Xml2JsonDto)JacksonUtil.getInstance().fromJson(handle.getExpression(), Xml2JsonDto.class);
                    if (xml2JsonConfig == null || !xml2JsonConfig.isEnabled()) continue block36;
                    targetBody = XmlToJson.toJson(targetBody, xml2JsonConfig.getForceArrPaths());
                    break;
                }
                case "2": {
                    targetBody = ShiftUtil.shift((String)businessKey, (String)targetBody, (String)handle.getExpression());
                    break;
                }
                case "3": {
                    if (!StringUtils.isNotBlank((CharSequence)handle.getExpression())) break;
                    Json2XmlDto xmlConfig = (Json2XmlDto)JacksonUtil.getInstance().fromJson(handle.getExpression(), Json2XmlDto.class);
                    if (!xmlConfig.isEnabled()) continue block36;
                    targetBody = Json2Xml.json2XML((String)targetBody, new HashSet());
                    break;
                }
                case "4": {
                    List pathList;
                    List configMapList = JacksonUtil.getInstance().fromJsonToList(handle.getExpression(), Map.class);
                    DocumentContext documentContext = JsonPath.parse((String)targetBody, (Configuration)CONF_AS_PATH_LIST);
                    JsonPathUtil.parse((String)targetBody);
                    for (Map entry : configMapList) {
                        Iterator sourceField = (String)entry.get("key");
                        String targetField = (String)entry.get("value");
                        if (StringUtils.isBlank(sourceField)) continue;
                        try {
                            String path = ((String)((Object)sourceField)).substring(0, ((String)((Object)sourceField)).lastIndexOf("."));
                            String val = ((String)((Object)sourceField)).substring(((String)((Object)sourceField)).lastIndexOf(".") + 1);
                            pathList = (List)documentContext.read(path, new Predicate[0]);
                            if (CollectionUtils.isEmpty((Collection)pathList)) continue;
                            pathList.forEach(finalPath -> {
                                String fPath = finalPath.replaceAll("\\['", ".").replaceAll("'\\]", "");
                                if (StringUtils.isBlank((CharSequence)targetField)) {
                                    if (JsonPath.isPathDefinite((String)finalPath)) {
                                        JsonPathUtil.add((String)fPath, (Object)val);
                                    }
                                } else if (targetField.startsWith("$")) {
                                    String nowVal = JsonPathUtil.getJson((String)fPath);
                                    String addPath = targetField.substring(0, targetField.lastIndexOf("."));
                                    String addVal = targetField.substring(targetField.lastIndexOf(".") + 1);
                                    if (StringUtils.isNotBlank((CharSequence)nowVal) && nowVal.equalsIgnoreCase(val)) {
                                        JsonPathUtil.add((String)addPath, (Object)addVal);
                                    }
                                } else {
                                    String nowVal = JsonPathUtil.getJson((String)fPath);
                                    if (StringUtils.isNotBlank((CharSequence)nowVal) && nowVal.equalsIgnoreCase(val)) {
                                        JsonPathUtil.delete((String)fPath);
                                        JsonPathUtil.add((String)fPath, (Object)targetField);
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            log.error("dictionay et error ,{},{}", sourceField, (Object)ex.getMessage());
                        }
                    }
                    targetBody = JsonPathUtil.getJson();
                    break;
                }
                case "5": {
                    if (!StringUtils.isNotBlank((CharSequence)handle.getExpression())) break;
                    List etList = JacksonUtil.getInstance().fromJsonToList(handle.getExpression(), ETDateFormat.class);
                    CONF_AS_PATH_LIST.addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
                    DocumentContext etDfContext = JsonPath.parse((String)targetBody, (Configuration)CONF_AS_PATH_LIST);
                    JsonPathUtil.parse((String)targetBody);
                    for (ETDateFormat dateFormat : etList) {
                        if ("system".equals(dateFormat.getSourceField())) {
                            String etDate = DateFormatUtils.format((Date)new Date(), (String)dateFormat.getTargetFormat());
                            JsonPathUtil.add((String)dateFormat.getTargetField(), (Object)etDate);
                            continue;
                        }
                        if (StringUtils.isBlank((CharSequence)dateFormat.getSourceField()) || StringUtils.isBlank((CharSequence)dateFormat.getSourceFormat()) || StringUtils.isBlank((CharSequence)dateFormat.getTargetFormat())) continue;
                        List pathList = null;
                        try {
                            pathList = (List)etDfContext.read(dateFormat.getSourceField(), new Predicate[0]);
                        }
                        catch (Exception ex) {
                            log.warn(ex.getMessage());
                            continue;
                        }
                        if (CollectionUtils.isEmpty((Collection)pathList)) continue;
                        for (String finalPath2 : pathList) {
                            String fPath = finalPath2.replaceAll("\\['", ".").replaceAll("'\\]", "");
                            String nowVal = JsonPathUtil.getJson((String)fPath);
                            if (StringUtils.isBlank((CharSequence)nowVal)) continue;
                            try {
                                Date dateTmp = null;
                                dateTmp = CUS_DATEFORMAT_TSMS.equalsIgnoreCase(dateFormat.getSourceFormat()) ? new Date(Long.parseLong(nowVal)) : DateUtils.parseDate((String)nowVal, (String[])new String[]{dateFormat.getSourceFormat()});
                                String etDate = null;
                                etDate = CUS_DATEFORMAT_TSMS.equalsIgnoreCase(dateFormat.getTargetFormat()) && dateTmp != null ? String.valueOf(dateTmp.getTime()) : DateFormatUtils.format((Date)dateTmp, (String)dateFormat.getTargetFormat());
                                if (StringUtils.isBlank((CharSequence)dateFormat.getTargetField())) {
                                    JsonPathUtil.add((String)fPath, (Object)etDate);
                                    continue;
                                }
                                JsonPathUtil.add((String)dateFormat.getTargetField(), (Object)etDate);
                            }
                            catch (Exception ex) {
                                log.error("date format exception,path:{},sourceFormat:{},targetFormat,{}", new Object[]{fPath, dateFormat.getSourceFormat(), dateFormat.getTargetFormat(), ex.getMessage()});
                            }
                        }
                    }
                    targetBody = JsonPathUtil.getJson();
                    break;
                }
                case "6": {
                    List etList;
                    List pathList;
                    if (!StringUtils.isNotBlank((CharSequence)handle.getExpression()) || CollectionUtils.isEmpty((Collection)(etList = JacksonUtil.getInstance().fromJsonToList(handle.getExpression(), ETCreatePKDto.class)))) break;
                    DocumentContext etDfContext = JsonPath.parse((String)targetBody, (Configuration)CONF_AS_PATH_LIST);
                    JsonPathUtil.parse((String)targetBody);
                    try {
                        for (ETCreatePKDto createPKDto : etList) {
                            String prePath = createPKDto.getTargetField().substring(0, createPKDto.getTargetField().lastIndexOf("."));
                            String sufPath = createPKDto.getTargetField().substring(createPKDto.getTargetField().lastIndexOf("."));
                            pathList = (List)etDfContext.read(prePath, new Predicate[0]);
                            if (CollectionUtils.isEmpty((Collection)pathList)) continue;
                            for (String finalPath3 : pathList) {
                                String fPath = finalPath3.replaceAll("\\['", ".").replaceAll("'\\]", "");
                                fPath = fPath + sufPath;
                                String id = "";
                                switch (createPKDto.getIdStrategy()) {
                                    case "mongoId": {
                                        id = IdUtil.objectId();
                                        break;
                                    }
                                    case "snowFlake": {
                                        id = IdUtil.getSnowflakeNextIdStr();
                                        break;
                                    }
                                    case "uuidSimple": {
                                        id = IdUtil.fastSimpleUUID();
                                        break;
                                    }
                                    case "uuid": {
                                        id = IdUtil.fastUUID();
                                        break;
                                    }
                                    default: {
                                        id = UniqIdUtils.getInstance().getUniqID();
                                    }
                                }
                                JsonPathUtil.add((String)fPath, (Object)id);
                            }
                        }
                    }
                    catch (Exception ex) {
                        log.error("add id field exception:{}", (Object)ex.getMessage());
                    }
                    targetBody = JsonPathUtil.getJson();
                    break;
                }
            }
        }
        return targetBody;
    }
}

