/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.xml2json;

import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlToJson {
    private static final Logger log = LoggerFactory.getLogger(XmlToJson.class);

    public static String toJson(String xmlBody, Set<String> forceArrSet) {
        JSONObject jsonObject = new JSONObject();
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xmlBody);
            Element root = document.getRootElement();
            XmlToJson.iterateXmlNodes(root, jsonObject, forceArrSet);
            return JacksonUtil.getInstance().toJson((Object)jsonObject);
        }
        catch (DocumentException e) {
            log.error("XML2Json exception", (Throwable)e);
            return null;
        }
    }

    private static void iterateXmlNodes(Element node, JSONObject json, Set<String> forceArrSet) {
        String nodeName = node.getName();
        if (json.containsKey((Object)nodeName)) {
            Object Object2 = json.get(nodeName);
            JSONArray array = null;
            if (Object2 instanceof JSONArray) {
                array = (JSONArray)Object2;
            } else {
                array = new JSONArray();
                array.add(Object2);
            }
            List listElement = node.elements();
            if (listElement.isEmpty()) {
                String nodeValue = node.getTextTrim();
                array.add((Object)nodeValue);
                json.put((Object)nodeName, (Object)array);
                return;
            }
            JSONObject newJson = new JSONObject();
            for (Element e : listElement) {
                XmlToJson.iterateXmlNodes(e, newJson, forceArrSet);
            }
            array.add((Object)newJson);
            json.put((Object)nodeName, (Object)array);
            return;
        }
        List listElement = node.elements();
        if (listElement.isEmpty()) {
            String nodeValue = node.getTextTrim();
            json.put((Object)nodeName, (Object)nodeValue);
            return;
        }
        JSONObject object = new JSONObject();
        for (Element e : listElement) {
            XmlToJson.iterateXmlNodes(e, object, forceArrSet);
        }
        if (CollectionUtils.isNotEmpty(forceArrSet) && forceArrSet.contains(node.getPath())) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)object);
            json.put((Object)nodeName, (Object)jsonArray);
        } else {
            json.put((Object)nodeName, (Object)object);
        }
    }
}

