package com.xforceplus.janus.bridgehead.core.config;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.JacksonUtil;

import org.apache.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 通过http 获取配置中心配置，获取配置的默认方式
 *
 * @Author: xuchuanhou
 * @Date:2021/12/29上午10:37
 */
@Slf4j
@NoArgsConstructor
@AllArgsConstructor
public class ConfigHttpBuilder implements com.xforceplus.janus.bridgehead.core.config.ConfigBuilder {

    private HttpConfig config;

    @Override
    public String buildConfig() {

        if (config == null || StringUtils.isEmpty(config.getAuthentication()) || StringUtils.isEmpty(config.getAction().getConfig())) {
            throw new NullPointerException("系统配置 action or Authentication is null");
        }

        Map<String, String> headers = new HashMap<>();
        headers.put("Authentication", config.getAuthentication());
        headers.put("action", config.getAction().getConfig());
        headers.put("serialNo", "" + System.currentTimeMillis());
        int retryTimes = 5;
        while (retryTimes > 0) {
            retryTimes--;
            try {
                HttpUtil.ResponseCus responseCus = HttpUtil.doGetEntire(config.getUrl(), null, false, headers);
                if (responseCus.getStatus() == HttpStatus.SC_OK) {
                    String finalReult = convertApiResult2TcpResult(responseCus.getBody());
                    if (StringUtils.isEmpty(finalReult)) {
                        log.error("fetchJanusConfig null:{}");
                        continue;
                    }
                    log.info("fetchJanusConfig : {}", responseCus.getBody());
                    return finalReult;
                }
            } catch (IOException ex) {
                log.error("fetchJanusConfig exception:{}", ErrorUtil.getStackMsg(ex));
                try {
                    Thread.sleep(1000 * 1);
                } catch (InterruptedException ircp) {
                }
            }
        }
        log.error("通过http 获取系统配置信息失败");
        throw new RuntimeException("从集成平台获取系统配置信息失败");
    }


    /**
     * API的配置中心信息结构修改与TCP 保持一致*
     *
     * @return
     */
    private String convertApiResult2TcpResult(String result) {
        // API的配置中心信息结构修改与TCP 保持一致
        Map<String, Object> resultMap = JacksonUtil.getInstance().fromJson(result, Map.class);
        if (resultMap == null || !String.valueOf(HttpStatus.SC_OK).equals(resultMap.get("code")) || resultMap.get("configs") == null) {
            return null;
        }

        List<Map> configs = JacksonUtil.getInstance().fromJsonToList(JacksonUtil.getInstance().toJson(resultMap.get("configs")), Map.class);
        if (CollectionUtils.isEmpty(configs)) {
            return null;
        }
        Map<String, Object> configsMap = new HashMap<>();
        configs.forEach(config -> {
            configsMap.put((String) config.get("configKey"), config.get("configValue"));
        });

        return JacksonUtil.getInstance().toJson(configsMap);
    }
}
