package com.xforceplus.janus.bridgehead.core.config;

import com.xforceplus.janus.bridgehead.core.init.JanusConfigInitRunnner;
import com.xforceplus.janus.bridgehead.core.init.MonitorDbConfigHandler;
import com.xforceplus.janus.bridgehead.core.init.UploadProjectConfigHandler;
import com.xforceplus.janus.bridgehead.core.monitor.JanusUploader;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/12下午3:25
 */
@Configuration
public class CoreAutoconfig {

    @Bean
    @ConfigurationProperties(prefix = "janus")
    public HttpConfig createHttpConfig() {
        return new HttpConfig();
    }

    @Bean
    public ConfigHttpBuilder createConfigBuilder(HttpConfig httpConfig) {
        return new ConfigHttpBuilder(httpConfig);
    }

    @Bean
    public JanusConfigInitRunnner createConfigRunner(List<ConfigHandler> configHandlerList,ConfigBuilder configBuilder) {
        return new JanusConfigInitRunnner(configHandlerList,configBuilder);
    }


    @Bean
    public MonitorDbConfigHandler createMonitorDbHandler(HttpConfig httpConfig) {
        return new MonitorDbConfigHandler(httpConfig);
    }


    @Bean
    public UploadProjectConfigHandler createUploadActionHandler(HttpConfig httpConfig) {
        return new UploadProjectConfigHandler(httpConfig);
    }

    @Bean
    public JanusUploader createJanusUploader(HttpConfig httpConfig) {
        return new JanusUploader(httpConfig);
    }

}
