package com.xforceplus.janus.bridgehead.core.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import lombok.Data;

/**
 * @program: bridgehead->MsgEventConfig
 * @description: 消息处理配置
 * @author: xuchuanhou
 * @create: 2020-09-02 18:33
 **/
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MsgEventConfig implements Serializable {

    public static final String DEALTYPE_HTTP_API = "1";
    public static final String DEALTYPE_DB = "2";
    public static final String DEALTYPE_RMQ = "3";

    private String requestName;

    private String dealType;
    /**
     * 调用接收到消息调用的http url
     */
    private String url;

    //rmq 交换机
    private String exchange;

    //rmq 队列
    private String queueName;

    private int priority;

    private TableInfo genTable;

    /**数据解决转换表达式*/
    private String etExpression;

}
