package com.xforceplus.janus.bridgehead.core.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2021/12/17下午3:56
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class TableColumnInfo {

    /**
     * 列名称
     */
    private String columnName;

    /**
     * 列描述
     */
    private String columnComment;

    /**
     * 列类型
     */
    private String columnType;

    /**
     * JAVA类型
     */
    private String javaType;

    /**
     * JAVA字段名
     */
    private String javaField;

    /**
     * 是否主键（1是）
     */
    private boolean pk;

    /**
     * 是否自增（1是）
     */
    private boolean increment;


    /**
     * 是否业务联合主键（1是）
     */
    private boolean unionKey;


    private String sqlSelect;

    private final boolean related=true;

    public String getSqlSelect() {
        if (sqlSelect != null) {
            return sqlSelect;
        }
        sqlSelect = this.columnName;
        if (related&& StringUtils.isNotBlank(this.javaField)) {
            sqlSelect += " AS " + this.javaField;
        }
        return sqlSelect;
    }
}
