package com.xforceplus.janus.bridgehead.core.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import lombok.Data;

import static java.util.stream.Collectors.joining;

/**
 * @Author: xuchuanhou
 * @Date:2021/12/17下午3:55
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class TableInfo {

    /**
     * 表名称
     */
    private String tableName;

    /**
     * 表描述
     */
    private String tableComment;

    /**
     * 实体类名称(首字母大写)
     */
    private String className;

    private boolean enableUpdate;

    private TableInfo subTable;

    private TableColumnInfo pkColumn;

    /**
     * 子类属性名称
     */
    private String subClassFieldName;

    /**
     * 关联子表名称
     */
    private String subTableName;

    /**
     * 子表外键
     */
    private String subTableFkName;

    /**
     * 表列信息
     */
    private List<TableColumnInfo> columns;

    public TableColumnInfo getPK() {
        if (pkColumn != null) {
            return pkColumn;
        }

        for (TableColumnInfo cl : this.columns) {
            if (cl.isPk()) {
                this.pkColumn = cl;
                return this.pkColumn;
            }
        }
        return null;
    }

    private Map<String, TableColumnInfo> javaFieldMap = new HashMap<>();

    public TableColumnInfo getColumn(String javaField) {

        if (javaFieldMap.isEmpty() && this.columns != null) {
            this.columns.forEach(col -> javaFieldMap.put(col.getColumnName(), col));
        }
        return javaFieldMap.get(javaField);
    }

    private List<String> fields = new ArrayList<>();

    public List<String> getTbFieldNames() {
        if (CollectionUtils.isNotEmpty(fields)) {
            return fields;
        }
        return this.columns.stream().map(co -> co.getColumnName()).collect(Collectors.toList());
    }

    private Map<String, TableColumnInfo> columnMap = new HashMap<>();

    public TableColumnInfo getJavaField(String columnName) {
        if (columnMap.isEmpty() && this.columns != null) {
            this.columns.forEach(col -> columnMap.put(col.getColumnName(), col));
        }
        return columnMap.get(columnName);
    }


    /**
     * 获取需要进行查询的 select sql 片段
     *
     * @param predicate 过滤条件
     * @return sql 片段
     */
    public String chooseSelect(Predicate<TableColumnInfo> predicate) {
        String pkSqlSelect = this.getPK().getColumnName();
        String fieldsSqlSelect = columns.stream().filter(predicate)
                .map(i -> i.getSqlSelect()).collect(joining(","));
        if (StringUtils.isNotEmpty(pkSqlSelect) && StringUtils.isNotEmpty(fieldsSqlSelect)) {
            return pkSqlSelect + "," + fieldsSqlSelect;
        } else if (StringUtils.isNotEmpty(fieldsSqlSelect)) {
            return fieldsSqlSelect;
        }
        return pkSqlSelect;
    }


   private List<TableColumnInfo> unionFields = null;

    public List<TableColumnInfo> getUnionFields() {
        if (CollectionUtils.isNotEmpty(unionFields)) {
            return unionFields;
        }

        List<TableColumnInfo> unionFields = new ArrayList<>();
        for (TableColumnInfo column : this.getColumns()) {
            if (column.isUnionKey()) {
                unionFields.add(column);
            }
        }
        return unionFields;
    }
}
