package com.xforceplus.janus.bridgehead.core.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2022/2/23下午2:58
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class ProjectDto implements Serializable {

    private String id;
    private String code;
    private String name;
    /**
     * 地址
     */
    private String address;
    /**
     * 属地客户端ID
     */
    private String clientId;

    /**
     * 客户自定义业务号
     */
    private String tenantId;
    private String token;

    private List<String> whiteAddress;

    private List<ProjectDto> children;

    /**
     * 提供的接口
     */
    private List<ApiDto> apisEntities;


    /**路由地址*/
    private String routeAddress;

}
