package com.xforceplus.janus.bridgehead.core.init;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.config.ConfigBuilder;
import com.xforceplus.janus.bridgehead.core.config.ConfigHandler;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.CommandLineRunner;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 系统初始化配置信息(从云端拉取配置信息)
 *
 * @Author: xuchuanhou
 * @Date:2021/12/29上午10:21
 */
@Slf4j
@AllArgsConstructor
//@Component
//public class JanusConfigInitRunnner implements InitializingBean {
public class JanusConfigInitRunnner implements CommandLineRunner{

//    @Autowired(required = false)
    private List<ConfigHandler> configHandlerList;

//    @Autowired
    private ConfigBuilder configBuilder;

//    @Override
//    public void afterPropertiesSet() {
//        String config = configBuilder.buildConfig();
//        if (StringUtils.isNotBlank(config)) {
//            dispatchConfig(config);
//        }
//    }
//
//    public void run(String... args) throws Exception {
//        this.fetchSysConfig();
//    }


    @Override
    public void run(String... args) throws Exception {
        String config = configBuilder.buildConfig();
        if (StringUtils.isNotBlank(config)) {
            dispatchConfig(config);
        }
    }

    @Scheduled(cron = "0 */5 * * * ?")
    protected  void fetchSysConfig(){
        try {
            String config = configBuilder.buildConfig();
            if (StringUtils.isEmpty(config)) {
                dispatchConfig(config);
            }
        }catch (Exception ex){

        }
    }


    /**
     * 分发到不同处理器
     */
    private void dispatchConfig(String body) {
        if (CollectionUtils.isEmpty(configHandlerList)) {
            return;
        }

        Map<String, Object> allConfigs = JacksonUtil.getInstance().fromJson(body, HashMap.class);
        for (ConfigHandler configHandler : configHandlerList) {
            log.info("system config key:{} init>>>>>>>>>>", configHandler.getConfigKey());
            Object configValue = allConfigs.get(configHandler.getConfigKey());
            if (configValue == null || StringUtils.isEmpty(configValue.toString())) {
                configHandler.nullValueHandler();
                continue;
            }
            String configJson = null;
            if (configValue instanceof String) {
                configJson = (String) configValue;
            } else {
                configJson = JacksonUtil.getInstance().toJson(configValue);
            }

            log.info("client init config:{} ,value:{}", configHandler.getConfigKey(), configJson);
            configHandler.doHandler(configJson);
        }
    }
}
