package com.xforceplus.janus.bridgehead.core.monitor.param;

import java.math.BigInteger;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/21下午1:44
 */
@Data
public class BusinessStaticsParam {


    /**
     *授权action
     * */
    private String action;

    /**
     *授权ID
     * */
    private String apiId;

    /**
     * 业务类型TCP,HTTP,TCL
     * */
    private String protocol;
    /**
     *提供方ID
     * */
    private String providerId;
    /**
     *调用方ID
     * */
    private String projectId;

    /**
     * 时间（yyyy-MM-dd HH:mm）
     * */
    private String ymdhm;

    /**
     *请求量
     * */
    private Integer reqNum = 0;
    /**
     *响应量
     * */
    private Integer resNum = 0;
    /**
     *失败量
     * */
    private Integer failNum = 0;
    /**
     *请求流量
     * */
    private BigInteger reqLen = BigInteger.ZERO;
    /**
     *响应流量
     * */
    private BigInteger resLen = BigInteger.ZERO;
    /**
     *耗时
     * */
    private BigInteger takeTime = BigInteger.ZERO;
}
