package com.xforceplus.janus.bridgehead.core.monitor.param;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/21下午12:47
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MonitorParam {

    public static final String MONITOR_TYPE_SYS = "system";

    public static final String MONITOR_TYPE_SERVICE = "service";

    public static final String DATA_TYPE_TCP = "tcp";
    public static final String DATA_TYPE_HTTP = "http";

    public static final String NOTICE_TYPE_DD = "dd";
    public static final String NOTICE_TYPE_EMAIL = "email";

    /**
     * 若接收人为空取值逻辑 0-项目，1-监控 0-项目ID 1-指标ID
     */
    private Integer monitorIdType = 0;

    /**
     * 监控类型,redis，system,service
     */
    private String monitorType;
    //消息队列
    private String objectType;
    //msgId
    private String code;
    //objectId
    private String objectId;
    //发送方userId
    private String providerNo;
    //接收方项目ID
    private String projectId;


    /**
     * 通知状态,已通知1，未通知0
     */
    private String noticeStatus = "1";

    private String noticeContent;

    private String noticeType;

    private String acceptor;

    private String indicator;

    /**
     * tcp,http
     */
    private String dataType = "tcp";

    private String monitorId;

    /**
     * 通知主题
     */
    private String subject;
}
