/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.config;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigBuilder;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ConfigHttpBuilder
implements ConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfigHttpBuilder.class);
    private HttpConfig config;
    public static final String KEY_PROJECT_CONFIG_VERSION = "projectConfigVersion";

    @Override
    public String buildConfig() {
        if (this.config == null || StringUtils.isEmpty((CharSequence)this.config.getAuthentication()) || StringUtils.isEmpty((CharSequence)this.config.getAction().getConfig())) {
            throw new NullPointerException("\u7cfb\u7edf\u914d\u7f6e action or Authentication is null");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authentication", this.config.getAuthentication());
        headers.put("action", this.config.getAction().getConfig());
        headers.put("serialNo", "" + System.currentTimeMillis());
        headers.put("Accept-Encoding", "etf");
        headers.put("janusVersion", this.config.getVersion());
        headers.put("clientType", this.config.getClientType());
        headers.put("clientVersion", this.config.getClientVersion());
        headers.put("curconfigversion", (String)HttpConfig.getConfig(KEY_PROJECT_CONFIG_VERSION));
        if (StringUtils.isNotBlank((CharSequence)this.config.getProxyHost())) {
            headers.put("proxyHost", this.config.getProxyHost());
            headers.put("proxyPort", this.config.getProxyPort());
        }
        int retryTimes = 5;
        while (retryTimes > 0) {
            --retryTimes;
            try {
                JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doGetEntire(this.config.getUrl(), null, false, headers);
                log.info("fetchJanusConfig1 status : {}", (Object)responseCus.getStatus());
                if (responseCus.getStatus() == 200) {
                    log.info("fetchJanusConfig1 : {}", (Object)responseCus.getBody());
                    String finalReult = this.convertApiResult2TcpResult(responseCus.getBody());
                    return finalReult;
                }
                throw new IOException("fetchJanusConfig \u5931\u8d25");
            }
            catch (IOException ex) {
                try {
                    JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(this.config.getUrl(), "{}", headers, null);
                    log.info("fetchJanusConfig2 status : {}", (Object)responseCus.getStatus());
                    if (responseCus.getStatus() == 200) {
                        log.info("fetchJanusConfig2 : {}", (Object)responseCus.getBody());
                        String finalReult = this.convertApiResult2TcpResult(responseCus.getBody());
                        return finalReult;
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception ircp) {
                    log.error("fetchJanusConfig exception:{},{}", (Object)ErrorUtil.getStackMsg((Exception)ex));
                }
            }
        }
        log.error("\u901a\u8fc7http \u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        throw new RuntimeException("\u4ece\u96c6\u6210\u5e73\u53f0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
    }

    public String convertApiResult2TcpResult(String result) throws IOException {
        Map resultMap = (Map)JacksonUtil.getInstance().fromJson(result, Map.class);
        if (resultMap == null || !String.valueOf(200).equals(resultMap.get("code")) || resultMap.get("configs") == null) {
            throw new IOException("fetch remote config center error");
        }
        List configs = JacksonUtil.getInstance().fromJsonToList(JacksonUtil.getInstance().toJson(resultMap.get("configs")), Map.class);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return null;
        }
        HashMap configsMap = new HashMap();
        configs.forEach(config -> configsMap.put((String)config.get("configKey"), config.get("configValue")));
        return JacksonUtil.getInstance().toJson(configsMap);
    }

    public ConfigHttpBuilder() {
    }

    public ConfigHttpBuilder(HttpConfig config) {
        this.config = config;
    }
}

