/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.init;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigBuilder;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class JanusConfigInitRunnner
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(JanusConfigInitRunnner.class);
    private List<ConfigHandler> configHandlerList;
    private ConfigBuilder configBuilder;
    private HttpConfig httpConfig;

    public void run(String ... args) throws Exception {
        this.jsonOrderInit();
        this.fetchSysConfig();
        String config = this.configBuilder.buildConfig();
        if (StringUtils.isNotBlank((CharSequence)config)) {
            this.dispatchConfig(config);
        }
    }

    private void jsonOrderInit() {
        if (!this.httpConfig.isJsonOrder()) {
            try {
                Field mappField = JacksonUtil.class.getDeclaredField("mapper");
                mappField.setAccessible(true);
                ObjectMapper mapper = (ObjectMapper)mappField.get(JacksonUtil.getInstance());
                mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, false);
            }
            catch (Exception e) {
                log.warn("\u53bb\u9664JSON\u5e8f\u5217\u5316\u6392\u5e8f \u5931\u8d25");
            }
        }
    }

    protected void fetchSysConfig() {
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(300000L);
                        String config = this.configBuilder.buildConfig();
                        if (!StringUtils.isNotBlank((CharSequence)config)) continue;
                        this.dispatchConfig(config);
                    }
                }
                catch (Exception ex) {
                    log.error("\u62c9\u53d6\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u5f02\u5e38", (Throwable)ex);
                    continue;
                }
                break;
            }
        }).start();
    }

    private void dispatchConfig(String body) {
        if (CollectionUtils.isEmpty(this.configHandlerList)) {
            return;
        }
        Map allConfigs = (Map)JacksonUtil.getInstance().fromJson(body, HashMap.class);
        for (ConfigHandler configHandler : this.configHandlerList) {
            log.info("system config key:{} init>>>>>>>>>>", (Object)configHandler.getConfigKey());
            Object configValue = allConfigs.get(configHandler.getConfigKey());
            if (configValue == null || StringUtils.isEmpty((CharSequence)configValue.toString())) {
                configHandler.nullValueHandler();
                continue;
            }
            String configJson = null;
            configJson = configValue instanceof String ? (String)configValue : JacksonUtil.getInstance().toJson(configValue);
            log.debug("client init config:{} ,value:{}", (Object)configHandler.getConfigKey(), (Object)configJson);
            configHandler.doHandler(configJson);
        }
        Set configKeys = this.configHandlerList.stream().map(cfh -> cfh.getConfigKey()).collect(Collectors.toSet());
        for (Map.Entry entry : allConfigs.entrySet()) {
            if (entry.getKey() == null && entry.getValue() == null || configKeys.contains(entry.getKey())) continue;
            this.httpConfig.setConfig((String)entry.getKey(), entry.getValue());
        }
    }

    public JanusConfigInitRunnner(List<ConfigHandler> configHandlerList, ConfigBuilder configBuilder, HttpConfig httpConfig) {
        this.configHandlerList = configHandlerList;
        this.configBuilder = configBuilder;
        this.httpConfig = httpConfig;
    }
}

