package com.xforceplus.janus.config.core.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.janus.config.core.dto.NodeApiDto;

import java.io.Serializable;

import lombok.Data;

/**
 * @program: bridgehead->MsgEventConfig
 * @description: 消息处理配置
 * @author: xuchuanhou
 * @create: 2020-09-02 18:33
 **/
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MsgEventConfig implements Serializable {

    public static final String DEALTYPE_HTTP_API = "1";
    public static final String DEALTYPE_DB = "2";
    public static final String DEALTYPE_RMQ = "3";
    /**数据转换*/
    public static final String DEALTYPE_JX = "4";


    private String requestName;

    private String dealType;
    /**
     * 调用接收到消息调用的http url
     */
    private NodeApiDto api;

    //rmq 交换机
    private String exchange;

    //rmq 队列
    private String queueName;

    private int priority;

    private String tbName;

    /**数据解决转换表达式*/
    private String etExpression;

}
